<?php $__env->startSection('title'); ?>
    Edit Setting
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customizedScript'); ?>
    <script>
        $(function(){
            CKEDITOR.replace("website_description_en");
            CKEDITOR.replace("website_description_ar");
        })
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Setting
            <small>Edit Setting</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="">Setting</a></li>
            <li class="active">Edit Setting</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        <?php if(session()->has('updated')): ?>
            <div class="alert alert-success" style="" role="alert">
                <?php echo e(session()->get('updated')); ?>

            </div>
        <?php endif; ?>
    </div>

    <section class="content">
        <form role="form" action="<?php echo e($setting->updateSettings()); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
          <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Setting Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12 with-border">
                                    <label for="exampleInputEmail1">Website Name</label>
                                    <input type="text"
                                           class="form-control"
                                           name="website_name_en"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Website Name" value="<?php echo e($setting->name_en); ?>">
                                    <p class="help-block"> Enter Name of website </p>
                                </div>

                                <div class="col-lg-12 with-border">
                                    <label for="website_description_en">Website Description</label>
                                    <textarea class="form-control"
                                              name="website_description_en"
                                              id="exampleInputEmail1"
                                              placeholder="Enter Website Description"
                                              rows="6"><?php echo e($setting->description_en); ?></textarea>
                                    <p class="help-block"> Enter Description of website </p>
                                </div>

                                <div class="col-lg-12 with-border">
                                    <label for="status" class="set-block">Status</label>
                                    <div class="radio radio-info  radio-inline">
                                        <input type="radio" id="inlineRadio1" value="1" name="status" <?php if($setting->active == 1): ?> checked="" <?php endif; ?>>
                                        <label for="inlineRadio1"> Publish </label>
                                    </div>
                                    <div class="radio radio-info  radio-inline">
                                        <input type="radio" id="inlineRadio2" value="0" name="status" <?php if($setting->active == 0): ?> checked="" <?php endif; ?>>
                                        <label for="inlineRadio2"> Un Publish </label>
                                    </div>
                                    <p class="help-block">Select Website Status .</p>
                                </div>

                                <div class="col-lg-12 with-border">

                                    <label for="website-logo">Logo</label>
                                    <img src="<?php if($setting->headerLogo): ?><?php echo e(asset($setting->headerLogo->path)); ?><?php endif; ?>" data-toggle="modal" data-target="#update-img" class="img-responsive change-logo">
                                    <p class="help-block">Current Logo</p>

                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Logo</label>
                                    <input type="file" class="form-control" name="h_logo" id="exampleInputEmail1" placeholder="Upload Website Logo">
                                    <p class="help-block"> Change Website Logo </p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Default Lang</label>
                                    <select name="default_lang" id="admin_type" class="form-control">
                                        <option value="0">Choose Default Lang</option>
                                        <option value="en" <?php if($setting->lang == 'en'): ?> selected="" <?php endif; ?>>English</option>
                                        <option value="ar" <?php if($setting->lang == 'ar'): ?> selected="" <?php endif; ?>>Arabic</option>
                                    </select>
                                </div>

                            </div>
                        </div>

                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">قم بتعديل اعدادات الموقع</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">اسم الموقع</label>
                                    <input type="text"
                                           class="form-control"
                                           name="website_name_ar"
                                           id="exampleInputEmail1"
                                           placeholder="ادخل اسم الموقع"
                                           value="<?php echo e($setting->name_ar); ?>">
                                </div>

                                <div class="col-lg-12 with-border">
                                    <label for="exampleInputEmail1">وصف الموقع</label>
                                    <textarea type="email"
                                              class="form-control"
                                              name="website_description_ar"
                                              id="exampleInputEmail1"
                                              placeholder="ادخل وصفا دقيقا للموقع" rows="6"><?php echo e($setting->description_ar); ?></textarea>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

    <?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\php\laravel\dr-abdo\resources\views/dashboard/setting/edit.blade.php ENDPATH**/ ?>