<?php $__env->startSection('title'); ?>
    services
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <h1>
            Services
            <small>All Services</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="">Service</a></li>
            <li class="active">All Services</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
    <?php if(session()->has('created')): ?>
        <div class="alert alert-success" style="" role="alert">
            <?php echo e(session()->get('created')); ?>

        </div>
    <?php endif; ?>

   <?php if(session()->has('updated')): ?>
        <div class="alert alert-success" style="" role="alert">
            <?php echo e(session()->get('updated')); ?>

        </div>
       <?php endif; ?>

    <?php if(session()->has('deleted')): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo e(session()->get('deleted')); ?>

        </div>
    <?php endif; ?>
    </div>

    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All Services Info</h3>
                        <a href="<?php echo e(route('admin.services.create')); ?>"
                           class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New Service </a>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example1" class="table table-bordered table-striped show-edit-category-table">
                                    <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>service title</th>
                                        <th>service subtitle</th>
                                        <th>Image</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                  <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <?php if(!$service->parent_service_id): ?>
                                        <tr>
                                            <td><?php echo e($service->id); ?></td>
                                            <td><?php echo e($service->services_en->title); ?></td>
                                            <td><?php echo e($service->services_en->sub_title); ?></td>
                                            <td>
                                                <div class="modal-btn" data-toggle="modal" data-target="#exampleModal">
                                                    <img style="width:50px;" src="<?php echo e(asset($service->image->path)); ?>"
                                                         alt="<?php echo e($service->image->alt); ?>">
                                                </div>
                                            </td>
                                            <td><?php echo e($service->created_at->format('D M Y')); ?></td>
                                            <td>
                                                <a href="<?php echo e($service->showImage()); ?>" class="" style="font-size: 20px"><i class="fa fa-image"></i> </a>
                                                <a href="<?php echo e($service->serviceEdit()); ?>" class="" style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                                <a href="<?php echo e($service->create_sub()); ?>" class="" style="font-size: 20px"><i class="fa fa-plus" title="Add Mini Services to this service"></i> </a>
                                                <a href="<?php echo e($service->show_sub()); ?>" class="" style="font-size: 20px"><i class="fa fa-eye" title="Show Sub-Services"></i> </a>
                                                <button type="button" class="" data-toggle="modal" data-target="#<?php echo e('delete'.$service->id); ?>" style="font-size: 20px">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                 <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modal modal-danger fade" id="<?php echo e('delete'.$service->id); ?>" style="display: none;">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span></button>
                                        <h4 class="modal-title">Delete Image</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Are You Sure You Want To Delete Service <?php echo e($service->services_en->title); ?></p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="<?php echo e($service->serviceDelete()); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <input type="hidden" name="_method" value="delete">
                                            <div class="d-flex flex-row">
                                                <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                    cancel
                                                </button>
                                                <button type="submit" class="btn btn-danger">
                                                    Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\php\laravel\dr-abdo\resources\views/dashboard/service/index.blade.php ENDPATH**/ ?>