@extends('website.layouts.layout')

@section('title' , 'service-details')


@section('content')

    <!--Page Title-->
    <section class="page-title" style="background-image:url({{asset('website/images/background/10.jpg')}});">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <div class="title-box">
                    <h1>{{$service->{'services_'.currentLang()}->title }}</h1>
                </div>
                <ul class="bread-crumb clearfix">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li>{{$service->{'services_'.currentLang()}->title }}</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->

    <!--Sidebar Page Container-->
    <div class="sidebar-page-container">
        <div class="auto-container">
            <div class="row clearfix">
                <!--Sidebar Side-->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar services-sidebar">

                        <!--Blog Category Widget-->
                        <div class="sidebar-widget sidebar-blog-category">
                            <ul class="blog-cat">
                                @php $current = $service->id; @endphp
                               @foreach($services as $service)
                                <li @if($service->id == $current) class="active" @endif>
                                    <a href="{{$service->view_service()}}"> {{$service->{'services_'.currentLang()}->title }} </a>
                                </li>
                                   @endforeach
                            </ul>
                        </div>




                        <!--Help Box-->
                        <div class="help-box" style="background-image:url({{asset($about->about_image->path)}})">
                            <div class="inner">
                                <span class="title">Quick Contact</span>
                                <h2>Contact Us</h2>
                                <div class="text">Contact us at Vertex or submit a business inquiry online.</div>
                                <a class="theme-btn btn-style-three" href="{{route('contact')}}">Contact</a>
                            </div>
                        </div>
                    </aside>
                </div>

                <!--Content Side-->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="service-detail">
                        <div class="inner-box">
                            <div class="image-box">
                                <div class="single-item-carousel owl-carousel owl-theme">
                                   @foreach($service->images as $image)
                                    <figure class="image"><img src="{{asset($image->path)}}" alt="" /></figure>
                                   @endforeach
                                </div>
                            </div>
                            <h2>{{$service->{'services_'.currentLang()}->title }}</h2>
                            <div class="text">
                                {!! $service->{'services_'.currentLang()}->description !!}
                                <div class="two-column row">
                                    <div class="column col-lg-6 col-md-6 col-sm-12">
                                        <h3>Our Key Features</h3>
                                       {!! $about->{'about_'.currentLang()}->features_text !!}
                                    </div>
                                    <div class="column col-lg-6 col-md-6 col-sm-12">
                                        <div class="image">
                                            <img src="{{asset($about->features_image->path)}}" alt="" />
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection