@extends('website.layouts.layout')

@section('title' , 'Home')


@section('content')

    <!-- Bnner Section -->
    <section class="banner-section">
        <div class="banner-carousel owl-carousel owl-theme">
            @foreach($mainSlider as $slide)
            <div class="slide-item" style="background-image: url({{asset($slide->image->path)}});">
                <div class="auto-container">
                    <div class="content-box">
                        <h2>{{  $slide->{'slider_'.currentLang()}->title  }}</h2>
                        <div class="text"> {{ $slide->{'slider_'.currentLang()}->description }}</div>
                        <div class="link-box">
                            <a href="{{$slide->btn_url}}" class="theme-btn btn-style-one">{{$slide->{'slider_'.currentLang()}->btn}}</a>
                        </div>
                    </div>
                </div>
            </div>
          @endforeach

        </div>

        <div class="bottom-box">
            <div class="auto-container clearfix">
                <ul class="contact-info">
                    <li><span>Phone :</span>

                        {{$contact->phone}}</li>
                    <li><span>EMAIL :</span> <a href="#">{{$contact->email}}</a></li>
                </ul>
            </div>
        </div>
    </section>
    <!-- End Bnner Section -->

    <!-- About Section -->
    <section class="about-section" style="background-image: url({{asset('website/images/background/1.jpg')}});">
        <div class="auto-container">
            <div class="row no-gutters">
                <!-- Image Column -->
                <div class="image-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="title-box wow fadeInLeft" data-wow-delay='1200ms'>
                            <h2>ABOUT <br> US</h2>
                        </div>
                        <div class="image-box">
                            <figure class="alphabet-img wow fadeInRight"><img src="{{asset('website/images/resource/image-1.png')}}" alt=""></figure>
                            <figure class="image wow fadeInRight" data-wow-delay='600ms'><img src="{{asset('website/images/resource/image-1.jpg')}}" alt=""></figure>
                        </div>
                    </div>
                </div>

                <!-- Content Column -->
                <div class="content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column wow fadeInLeft">
                        <div class="content-box">
                            <div class="title">
                                <h2>THROUGHOUT THE PAST 5 YEARS  <br>WE DEVELOPED</h2>
                            </div>
                            <div class="text">{!! $about->{'about_'.currentLang()}->description !!}</div>
                            <div class="link-box"><a href="{{route('about')}}" class="theme-btn btn-style-one">About Us</a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End About Section -->

    <!-- Services Section -->
    <section class="services-section">
        <div class="upper-box" style="background-image: url({{asset('website/images/background/2.jpg')}});">
            <div class="auto-container">
                <div class="sec-title text-center light">
                    <span class="float-text">Specialization</span>
                    <h2>Our Specialization</h2>
                </div>
            </div>
        </div>

        <div class="services-box">
            <div class="auto-container">
                <div class="services-carousel owl-carousel owl-theme">

                    @foreach($services as $service)
                    <!-- Service Block -->
                    <div class="service-block">
                        <div class="inner-box">
                            <div class="image-box">
                                <figure class="image"><a href="{{$service->view_service()}}"><img src="{{asset($service->image->path)}}" alt=""></a></figure>
                            </div>
                            <div class="lower-content">
                                <h3><a href="{{$service->view_service()}}">{{$service->{'services_'.currentLang()}->title }}</a></h3>
                                <div class="text">  {!! $service->{'services_'.currentLang()}->description !!}</div>
                                <div class="link-box">
                                    <a href="{{$service->view_service()}}">Lorn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                 @endforeach




                </div>
            </div>
        </div>
    </section>
    <!--End Services Section -->

    <!-- Fun Fact Section -->
    <section class="fun-fact-section">
        <div class="outer-box" style="background-image: url({{asset('website/images/background/3.jpg')}});">
            <div class="auto-container">
                <div class="fact-counter">
                    <div class="row">
                        <!--Column-->
                        <div class="counter-column col-lg-3 col-md-6 col-sm-12 wow fadeInUp">
                            <div class="count-box">
                                <div class="count"><span class="count-text" data-speed="5000" data-stop="14">0</span></div>
                                <h4 class="counter-title">Years of <br>Experience</h4>
                            </div>
                        </div>

                        <!--Column-->
                        <div class="counter-column col-lg-3 col-md-6 col-sm-12 wow fadeInUp" data-wow-delay="400ms">
                            <div class="count-box">
                                <div class="count"><span class="count-text" data-speed="5000" data-stop="237">0</span></div>
                                <h4 class="counter-title">Project <br>Taken</h4>
                            </div>
                        </div>

                        <!--Column-->
                        <div class="counter-column col-lg-3 col-md-6 col-sm-12 wow fadeInUp" data-wow-delay="800ms">
                            <div class="count-box">
                                <div class="count"><span class="count-text" data-speed="5000" data-stop="11">0</span>K</div>
                                <h4 class="counter-title">Twitter <br> Follower</h4>
                            </div>
                        </div>

                        <!--Column-->
                        <div class="counter-column col-lg-3 col-md-6 col-sm-12 wow fadeInUp" data-wow-delay="1200ms">
                            <div class="count-box">
                                <div class="count"><span class="count-text" data-speed="5000" data-stop="12">0</span></div>
                                <h4 class="counter-title">Awards<br>won</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End Fun Fact Section -->

    <!-- Project Section -->
    <section class="projects-section">
        <div class="auto-container">
            <div class="sec-title text-right">
                <span class="float-text">Project</span>
                <h2>Our Project</h2>
            </div>
        </div>

        <div class="inner-container">
            <div class="projects-carousel owl-carousel owl-theme">

              @foreach($albums as $album)
                <div class="project-block">
                    <div class="image-box">
                        <figure class="image"><img src="{{asset($album->image->path)}}" alt=""></figure>
                        <div class="overlay-box">
                            <h4><a href="{{$album->view()}}">{{$album->{'album_'.currentLang()}->title }} <br>Project</a></h4>
                            <div class="btn-box">
                                <a href="{{asset($album->image->path)}}" class="lightbox-image" data-fancybox="gallery"><i class="fa fa-search"></i></a>
                                <a href="{{$album->view()}}"><i class="fa fa-external-link"></i></a>
                            </div>
                            <span class="tag">{{$album->{'album_'.currentLang()}->description }}</span>
                        </div>
                    </div>
                </div>
            @endforeach



            </div>
        </div>
    </section>
    <!--End Project Section -->

    <!-- before-after -->
    <section class="section-md">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-md-9">
                    <div class="section-title text-center">
                        <h2><strong>Before And After</strong></h2>
                    </div>
                </div>
            </div>
            <div class="row">

                @foreach($projects as $project)
                <div class="col-md-4 mb-4">
                    <div  class="twentytwenty-container">
                        <img src="{{asset($project->beforeImage->path)}}" class="img-fluid w-100" alt="">
                        <img src="{{asset($project->afterImage->path)}}" class="img-fluid w-100" alt="">
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </section>
    <!-- before-after end -->
    <!-- Testimonial Section -->
    <section class="testimonial-section">
        <div class="outer-container clearfix">
            <!-- Title Column -->
            <div class="title-column clearfix">
                <div class="inner-column">
                    <div class="sec-title">
                        <span class="float-text">testimonial</span>
                        <h2>What Client Says</h2>
                    </div>
                    <div class="text">Looking at its layout. The point of using very profectly is that it has a more-or-less normal distribution of letters, as opposed</div>
                </div>
            </div>

            <!-- Testimonial Column -->
            <div class="testimonial-column clearfix" style="background-image: url({{asset('website/images/background/4.jpg')}});">
                <div class="inner-column">
                    <div class="testimonial-carousel owl-carousel owl-theme">
                        <!-- Testimonial Block -->
                     @foreach($comments as $comment)
                        <div class="testimonial-block">
                            <div class="inner-box">
                                <div class="image-box"><img src="{{asset($comment->image->path)}}" alt=""></div>
                                <div class="text"> {!! $comment->{'comment_'.currentLang()}->comment !!} </div>
                                <div class="info-box">
                                    <h4 class="name">{{$comment->{'comment_'.currentLang()}->fullname }}</h4>
                                    <span class="designation">{{$comment->{'comment_'.currentLang()}->job_title }}</span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End Testimonial Section -->

    <!-- News Section Two -->
    <section class="news-section-two">
        <div class="auto-container">
            <div class="sec-title">
                <span class="float-text">Portfolio</span>
                <h2>Our Portfolio</h2>
            </div>

            <div class="row">
                         <div class="column col-lg-3 col-md-12 col-sm-12">

                            @foreach($albums as $key => $value)
                                @if($key == 0 || $key == 1)
                             <div class="news-block-four">
                                 <div class="inner-box">
                                     <div class="image-box">
                                         <figure class="image"><img src="{{asset($value->image->path)}}" alt=""></figure>
                                         <div class="overlay-box"><a href="{{$value->view()}}"><i class="fa fa-link"></i></a></div>
                                     </div>

                                 </div>
                             </div>
                                @endif
                                @if($key == 2) @break @endif
                           @endforeach

                         </div>

                         <div class="column col-lg-6 col-md-12 col-sm-12">
                             <div class="inner-column">
                                 <!-- News Block -->
                                 @foreach($albums as $key => $value)
                                     @if($key == 2)
                                 <div class="news-block-three">
                                     <div class="inner-box">
                                         <div class="image-box">
                                             <figure class="image"><img src="{{asset($value->image->path)}}" alt=""></figure>
                                             <div class="overlay-box"><a href="{{$value->view()}}"><i class="fa fa-link"></i></a></div>
                                         </div>

                                     </div>
                                 </div>
                                     @endif
                                         @if($key == 3) @break @endif
                                 @endforeach
                             </div>


                         </div>
                         <div class="column col-lg-3 col-md-12 col-sm-12">
                             @foreach($albums as $key => $value)
                                 @if($key == 3 || $key == 4)
                                     <div class="news-block-four">
                                         <div class="inner-box">
                                             <div class="image-box">
                                                 <figure class="image"><img src="{{asset($value->image->path)}}" alt=""></figure>
                                                 <div class="overlay-box"><a href="{{$value->view()}}"><i class="fa fa-link"></i></a></div>
                                             </div>

                                         </div>
                                     </div>
                                 @endif
                                 @if($key == 5) @break @endif
                             @endforeach
                         </div>
            </div>
        </div>
    </section>
    <!--End News Section Two -->
    <!-- News Section -->
    <section class="news-section">
        <div class="auto-container">
            <div class="sec-title">
                <span class="float-text">Blogs</span>
                <h2>News & Articals</h2>
            </div>
            <div class="row">
                <!-- News Block -->
                @foreach($blogs as $blog)
                <div class="news-block col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-box">
                        <div class="image-box">
                            <figure class="image"><img src="{{asset($blog->image->path)}}" alt=""></figure>
                            <div class="overlay-box"><a href="{{$blog->showBlog()}}"><i class="fa fa-link"></i></a></div>
                        </div>
                        <div class="caption-box">
                            <h3><a href="{{$blog->showBlog()}}">{{$blog->{'blog_'.currentLang()}->title }}</a></h3>
                            <ul class="info">
                                <li>{{$blog->created_at->format('d M Y')}}</li>
                                <li>{{ $blog->{'blog_'.currentLang()}->author }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
               @endforeach



            </div>
        </div>
    </section>
    <!--End News Section -->
    <!--Clients Section-->
    <section class="clients-section">
        <div class="inner-container">
            <div class="sponsors-outer">
                <!--Sponsors Carousel-->
                <ul class="sponsors-carousel owl-carousel owl-theme">

                    @foreach($clientSlider as $slider)
                     <li class="slide-item"><figure class="image-box"><a href="{{$slider->btn_url}}"><img src="{{asset($slider->image->path)}}" alt=""></a></figure></li>
                    @endforeach

                </ul>
            </div>
        </div>
    </section>
    <!--End Clients Section-->

    @endsection
