@extends('website.layouts.layout')

@section('title' , 'News')

@section('content')
    <!--Page Title-->
    <section class="page-title" style="background-image:url({{asset('website/images/background/10.jpg')}});">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <div class="title-box">
                    <h1>News & Artical</h1>
                </div>
                <ul class="bread-crumb clearfix">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li>Blogs</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->

    <!-- Blog Section -->
    <section class="blog-section">
        <div class="auto-container">
            <div class="row">

                @foreach($blogs as $blog)
                <div class="news-block-two col-lg-4 col-md-12 col-sm-12">
                    <div class="inner-box">
                        <div class="image-box">
                            <figure class="image"><img src="{{asset($blog->image->path)}}" alt=""></figure>
                            <div class="overlay-box"><a href="{{$blog->showBlog()}}"><i class="fa fa-link"></i></a></div>
                        </div>
                        <div class="caption-box">
                            <div class="inner">
                                <h3><a href="{{$blog->showBlog()}}">{{$blog->{'blog_'.currentLang()}->title }}</a></h3>
                                <ul class="info">
                                    <li>{{$blog->created_at->format('d M Y')}}</li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
             @endforeach

            </div>

            {{$blogs->links()}}

        </div>
    </section>
    <!--End Blog Section -->
    @endsection