@extends('website.layouts.layout')

@section('title' , 'projects')

@section('content')
    <!--Page Title-->
    <section class="page-title" style="background-image:url({{asset('website/images/background/10.jpg')}});">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <div class="title-box">
                    <h1>Projects</h1>
                </div>
                <ul class="bread-crumb clearfix">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li>Projects</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->

    <!-- Projects Section -->
    <section class="projects-section alternate">
        <div class="auto-container">
            <!--MixitUp Galery-->
            <div class="mixitup-gallery">

                <div class="filter-list row">

                    @foreach($albums as $album)
                    <div class="project-block col-lg-4 col-md-6 col-sm-12">
                        <div class="image-box">
                            <figure class="image"><img src="{{asset($album->image->path)}}" alt=""></figure>
                            <div class="overlay-box">
                                <h4><a href="{{$album->view()}}">{{$album->{'album_'.currentLang()}->title }} <br>Project</a></h4>
                                <div class="btn-box">
                                    <a href="{{asset($album->image->path)}}" class="lightbox-image" data-fancybox="gallery"><i class="fa fa-search"></i></a>
                                    <a href="{{$album->view()}}"><i class="fa fa-external-link"></i></a>
                                </div>
                                <span class="tag">{{$album->{'album_'.currentLang()}->description }}</span>
                            </div>
                        </div>
                    </div>
                 @endforeach



                </div>
            </div>

            <!--Post Share Options-->
            {{$albums->links() }}

        </div>
    </section>
    @endsection