@extends('dashboard.layouts.layouts')

@section('title')
    sliders
@endsection

@section('content')
    <section class="content-header">
        <h1>
            slider
            <small>All Sliders</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('admin.slider.index')}}">Sliders</a></li>
            <li class="active">show</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        @if(session()->has('created'))
            <div class="alert alert-success" style="" role="alert">
                {{ session()->get('created') }}
            </div>
        @endif

        @if(session()->has('updated'))
            <div class="alert alert-success" style="" role="alert">
                {{ session()->get('updated') }}
            </div>
        @endif

        @if(session()->has('deleted'))
            <div class="alert alert-danger" role="alert">
                {{ session()->get('deleted') }}
            </div>
        @endif
    </div>

    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">

                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">Sliders</h3>
                                                <a href="{{route('admin.slider.create')}}"
                                                   class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New Slider </a>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example1" class="table table-bordered table-striped show-edit-category-table">
                                    <thead>
                                    <tr>
                                        <th>Id</th>
                                        @if(!Request::url() == route('admin.slider.index'))
                                        <th>Image</th>
                                        @endif
                                        <th>Title</th>
                                        <th>Created by</th>
                                        <th>Created at</th>
                                        <th>Updated at</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($sliders as $slider )
                                        <tr role="row" class="even">
                                            <td class="sorting_1">{{$slider->id}}</td>
                                            @if(!Request::url() == route('admin.slider.index'))
                                            <td><img src="{{asset($slider->image->path)}}" style="width: 50px" alt="{{$slider->image->alt}}"> </td>
                                            @endif
                                            <td>{{$slider->slider_en->title}}</td>
                                            <td>{{$slider->user->name}}</td>
                                            <td>{{$slider->created_at->format('D M Y')}}</td>
                                            <td>{{$slider->updated_at->format('D M Y')}}</td>
                                            <td>
                                                <a href="{{$slider->slideEdit()}}" class="" style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                                <a href="{{$slider->createSubSlider()}}" class="" style="font-size: 20px"><i class="fa fa-plus" title="Add Mini Slider to this slider"></i> </a>
                                                <a href="{{$slider->show_sub()}}" class="" style="font-size: 20px"><i class="fa fa-eye" title="Show Sub-Services"></i> </a>
                                                <button type="button" class="" data-toggle="modal" data-target="{{'#delete'.$slider->id}}" style="font-size: 20px">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>

                    @foreach($sliders as $slider )
                        <div class="modal modal-danger fade" id="{{'delete'.$slider->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span></button>
                                        <h4 class="modal-title">Delete Slide</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Are You Sure You Want To Delete Slide <strong>{{$slider->slider_en->title}}</strong></p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="{{$slider->slideDelete()}}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <div class="d-flex flex-row">
                                                <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                    cancel
                                                </button>
                                                <button type="submit" class="btn btn-danger">
                                                    Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    @endforeach
                </div>
            </div>
        </div>
    </section>

@endsection('content')