@extends('dashboard.layouts.layouts')
@section('title', 'Dashboard')
<!-- Drop Your Customized Style Here -->
@section('customizedStyle')
@endsection
<!-- Drop Your Customized Scripts Here -->
@section('customizedScript')
@endsection
<!-- Start of content section -->
@section('content')


    <section class="content-header">
        <h1>
            Album
            <small>Show Album Images</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl('/album')}}">Album</a></li>
            <li class="active">Update Album</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">

        @if(session()->has('deleted'))
            <div class="alert alert-danger" role="alert">
                {{ session()->get('deleted') }}
            </div>
        @endif
    </div>

    <section class="content container-fluid">
        @include('dashboard.layouts.messages')
        <div class="images-wrapper">
            <ul>
                @if($images)
                    @foreach($images as $image)
                        <li>
                            <div class="remove-btn modal-btn" data-toggle="modal" data-target="#delete{{$image->id}}">
                                <i class="ion-ios-close-empty"></i>
                            </div>
                            <img src="{{asset($image->path)}}" alt="{{$image->alt}}">
                        </li>
                    @endforeach
                @endif
            </ul>
        </div>

        @if($images)
            @foreach($images as $image)
                <div class="modal modal-danger fade" id="delete{{$image->id}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Delete Image</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are You Sure You Want To Delete Image</p>
                            </div>
                            <div class="modal-footer">
                                <form action="{{$image->imageDelete()}}" method="post">
                                    @method('delete')
                                    @csrf
                                    <div class="d-flex flex-row">
                                        <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                            cancel
                                        </button>
                                        <button type="submit" class="btn btn-danger">
                                            Delete
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
            @endforeach
        @endif
    </section>

@endsection



