@extends('dashboard.layouts.layouts')

@section('title')
    Update Blog
@endsection

@section('content')

    <section class="content-header">
        <h1>
            Blog
            <small>Update</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('admin.blog.index')}}">Blogs</a></li>
            <li class="active">Update Blog</li>
        </ol>
    </section>

    @include('dashboard.layouts.messages')

    <section class="content">
        <form role="form" action="{{$blog->blogUpdate()}}" enctype="multipart/form-data" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Blog Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Title</label>
                                    <input type="text"
                                           class="form-control"
                                           style="@error('title_en') border-color:red; @enderror"
                                           name="title_en"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Blog Title"
                                           value="{{$blog->blog_en->title}}">
                                    <p class="help-block">Enter title of blog</p>

                                    @error('title_en')
                                      <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Blog Author</label>
                                    <input type="text"
                                           class="form-control"
                                           style="@error('author_en') border-color:red; @enderror "
                                           name="author_en"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Blog Title"
                                           value="{{$blog->blog_en->author}}">
                                    <p class="help-block">Enter Author of blog</p>

                                    @error('author_en')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>


                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Blog Url</label>
                                    <input type="text"
                                           class="form-control"
                                           style="@error('url') border-color:#ff0600; @enderror"
                                           name="url"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Blog slug"
                                           value="{{$blog->url}}">
                                    <p class="help-block">Enter Url of Article which will shown in url <strong>If Url is empty, system will choose article title as url by Default</strong></p>
                                    @error('url')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror

                                </div>

                                <div class="col-lg-12">
                                    <label for="subject_en"> Blog Subject</label>
                                    <textarea
                                            class=" form-control"
                                            name="subject_en"
                                            id="subject_en"
                                    >{{$blog->blog_en->subject}}</textarea>
                                    <p class="help-block">Enter Subject of Blog</p>
                                    @error('subject_en')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input
                                            type="file"
                                            class="form-control"
                                            style="@error('image') border-color:#ff0600; @enderror"
                                            name="image"
                                            id="exampleInputEmail1"
                                            placeholder="Enter Blog text">
                                    <p class="help-block"> Upload Blog Image </p>
                                    @error('image')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>

{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1">Image Alt Text</label>--}}
{{--                                    <input--}}
{{--                                            type="text"--}}
{{--                                            class="form-control"--}}
{{--                                            name="img_alt"--}}
{{--                                            style="@error('img_alt') border-color:#ff0600; @enderror"--}}
{{--                                            id="exampleInputEmail1"--}}
{{--                                            placeholder="Enter Alt Text"--}}
{{--                                            value="{{$blog->image->alt}}">--}}
{{--                                    <p class="help-block"> Enter Alt Text for Image to show it if image isn't loaded , The Alt Text will not change unless an image is uploaded </p>--}}
{{--                                    @error('img_alt')--}}
{{--                                    <p class="text-danger">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                </div>--}}


{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1"> Blog Images</label>--}}
{{--                                    <input type="file"--}}
{{--                                           class="form-control"--}}
{{--                                           style="@error('images') border-color:#ff0600; @enderror"--}}
{{--                                           name="images[]"--}}
{{--                                           multiple=""--}}
{{--                                           id="exampleInputEmail1"--}}
{{--                                           placeholder="Enter Blog text">--}}
{{--                                    <p class="help-block"> Upload <strong>Images</strong></p>--}}
{{--                                    @error('images')--}}
{{--                                    <p class="text-danger">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                </div>--}}



                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات المقالة</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> عنوان المقالة</label>
                                    <input type="text"
                                           class="form-control"
                                           name="title_ar"
                                           id="editor10"
                                           style="text-align: right; @error('title_ar') border-color:#ff0600; @enderror"
                                           placeholder="ادخل عنوان المقالة"
                                           value="{{$blog->blog_ar->title}}">
                                    <p class="help-block">أضف عنوان المقالة</p>
                                    @error('title_ar')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> ناشر المقالة</label>
                                    <input type="text"
                                           class="form-control"
                                           name="author_ar"
                                           id="editor10"
                                           style="text-align: right; @error('author_ar') border-color:#ff0600; @enderror"
                                           placeholder="ادخل عنوان المقالة"
                                           value="{{$blog->blog_ar->author}}">
                                    <p class="help-block">أضف ناشر المقالة</p>
                                    @error('author_ar')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>



                                <div class="col-lg-12">
                                    <label for="ardisc"> موضوع المقالة</label>
                                    <textarea class="form-control"
                                              name="subject_ar"
                                              id="subjectar"
                                              style="text-align: right;"
                                    >{{$blog->blog_ar->subject}}</textarea>
                                    <p class="help-block">ادخل موضوع المقالة</p>
                                    @error('subject_ar')
                                    <p class="text-danger">{{$message}}</p>
                                    @enderror
                                </div>



                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

@endsection('content')

@section('customizedScript')
    <script>
        $(function(){
            CKEDITOR.replace("subject_en");
            CKEDITOR.replace("subject_ar");
        })
    </script>
@endsection