@extends('dashboard.layouts.layouts')
@section('title', 'Dashboard')
<!-- Drop Your Customized Style Here -->
@section('customizedStyle')
    <style>
        .video-box{
            width:400px;
            height: 300px;
        }

        .video-box iframe{
            width:100%;
            height:100%;
        }



        .remove-btn-custom {
            position: absolute;
            top: 0;
            left: 0;
        }

        .custom-li {
            display: grid;
            position: relative;
        }

        .custom-button-li{
            font-size: 22px;
            width: 32px;
            height: 32px;
            line-height: 1;
            display: grid;
            align-content: center;
            justify-items: center;
            cursor: pointer;
            color: #fff;
            background-color: rgba(0, 0, 0, 0.685);
        }

        @media only screen and (min-width: 992px) {
            .custom-button-li {
                font-size: 38px;
                width: 40px;
                height: 40px;
            }
        }

        .custom-button-li:hover {
            background-color: rgba(0, 0, 0, 0.863);
            color: red;
            transition: all .4s ease-out;
        }


    </style>
@endsection
<!-- Drop Your Customized Scripts Here -->
@section('customizedScript')
@endsection
<!-- Start of content section -->
@section('content')


    <section class="content-header">
        <h1>
            Album
            <small>Show Album Videos</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl('/albums')}}">Album</a></li>
            <li class="active">Update Album</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        @if(session()->has('deleted'))
            <div class="alert alert-danger" role="alert">
                {{ session()->get('deleted') }}
            </div>
        @endif
    </div>

    <section class="content container-fluid">
        @include('dashboard.layouts.messages')
        <div class="images-wrapper cus-height">
            <ul>
                @if($videos)
                    @foreach($videos as $video)
                        <li class="custom-li">
                            <div class="video-box">
                                <div class="remove-btn-custom modal-btn"  data-toggle="modal"  data-target="#delete{{$video->id}}">
                                    <i class="ion-ios-close-empty custom-button-li"></i>
                                </div>
                            <iframe  src="{{$video->url}}" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                             </div>
                        </li>
                    @endforeach
                @endif
            </ul>
        </div>

        @if($videos)
            @foreach($videos as $video)
                <div class="modal modal-danger fade" id="delete{{$video->id}}">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Delete Video</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are You Sure You Want To Delete Video Url</p>
                            </div>
                            <div class="modal-footer">
                                <form action="{{$video->videoDelete()}}" method="post">
                                    @method('delete')
                                    @csrf
                                    <div class="d-flex flex-row">
                                        <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                            cancel
                                        </button>
                                        <button type="submit" class="btn btn-danger">
                                            Delete
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
            @endforeach
        @endif
    </section>

@endsection



