@extends('dashboard.layouts.layouts')

@section('title')
    Edit About
@endsection
@section('customizedScript')
    <script>
        $(function(){
            CKEDITOR.replace("description_en");
            CKEDITOR.replace("description_ar");
            CKEDITOR.replace("mission_en");
            CKEDITOR.replace("mission_ar");
            CKEDITOR.replace("vision_en");
            CKEDITOR.replace("vision_ar");
            CKEDITOR.replace("features_en");
            CKEDITOR.replace("features_ar");
            // CKEDITOR.replace("values_en");
            // CKEDITOR.replace("values_ar");
            // CKEDITOR.replace("goals_en");
            // CKEDITOR.replace("goals_ar");

        });




    </script>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            About
            <small>Edit About Website</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl('/about/1/edit')}}">About</a></li>
            <li class="active">Edit About Website</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        @if(session()->has('updated'))
            <div class="alert alert-success" style="" role="alert">
                {{ session()->get('updated') }}
            </div>
        @endif
    </div>


    <section class="content">
        <form role="form" action="{{$about->aboutUpdate()}}" enctype="multipart/form-data" method="post">
            @csrf
            @method('PUT')
                <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit About Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">About Company</label>
                                    <textarea type="text"
                                              class="form-control"
                                              id="editor1"
                                              name="description_en"
                                              placeholder="Enter Mission of Website" rows="5">{{$about->about_en->description}}</textarea>

                                    @error('description_en')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">Edit About website</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Website Features</label>
                                    <textarea type="text"
                                              class="form-control"
                                              id="editor1"
                                              name="features_en"
                                              placeholder="Enter Mission of Website" rows="5">{{$about->about_en->features_text}}</textarea>

                                    @error('features_en')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">Edit website features</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Mission</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="mission_en"
                                              id="editor2"
                                              rows="6"
                                              placeholder="Enter Mission of Website">{{$about->about_en->mission_text}}</textarea>
                                    @error('mission_en')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">Edit Mission of website</p>
                                </div>


                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Vision</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="vision_en"
                                              id="editor3"
                                              rows="6" placeholder="Enter Vision of Website">{{$about->about_en->vision_text}}</textarea>
                                    @error('vision_en')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">Edit Vision of website</p>
                                </div>





{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1">Values</label>--}}
{{--                                    <textarea type="text"--}}
{{--                                              class="form-control editor1"--}}
{{--                                              name="values_en"--}}
{{--                                              id="editor4"--}}
{{--                                              rows="6"--}}
{{--                                              placeholder="Enter Values of Website">{{$about->about_en->values_text}}</textarea>--}}
{{--                                    @error('values_en')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">Edit Values of website</p>--}}
{{--                                </div>--}}

{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1">goals</label>--}}
{{--                                    <textarea type="text"--}}
{{--                                              class="form-control editor1"--}}
{{--                                              name="goals_en"--}}
{{--                                              id="editor4"--}}
{{--                                              rows="6"--}}
{{--                                              placeholder="Enter Values of Website">{{$about->about_en->goals_text}}</textarea>--}}
{{--                                    @error('goals_en')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">Edit Goals of website</p>--}}
{{--                                </div>--}}


{{--                                <div class="col-lg-12" style="margin-bottom:20px;">--}}
{{--                                    <label for="about_vid">About Video Link</label>--}}
{{--                                     <input class="form-control" type="text" name="about_vid" id="about_vid" value="{{$about->about_vid}}" >--}}
{{--                                    @error('about_vid')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">Edit About Video of website</p>--}}
{{--                                </div>--}}

{{--                                <div class="col-lg-12" style="margin-bottom:20px;">--}}
{{--                                    <label for="mission_vid">Vision Video Link</label>--}}
{{--                                    <input class="form-control" type="text" name="vision_vid" id="mission_vid" value="{{$about->vision_vid}}" >--}}
{{--                                    @error('mission_vid')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">Edit Vision Video of website</p>--}}
{{--                                </div>--}}


                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> About Us Image</label>
                                    <input type="file" class="form-control" name="about_image_id" id="exampleInputEmail1" placeholder="Update About Image">
                                    <p class="help-block"> Update The Image in About Section</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> features Image</label>
                                    <input type="file" class="form-control" name="features_image_id" id="exampleInputEmail1" placeholder="Update About Image">
                                    <p class="help-block"> Update The Image in features Section</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Mission Image</label>
                                    <input type="file" class="form-control" name="mission_image_id" id="exampleInputEmail1" placeholder="Update Mession Image">
                                    <p class="help-block"> Update The Image in Mission Section</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Vision Image</label>
                                    <input type="file" class="form-control" name="vision_image_id" id="exampleInputEmail1" placeholder="Update Vision Image">
                                    <p class="help-block"> Update The Image in Vision Section</p>
                                </div>



{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1"> Values Image</label>--}}
{{--                                    <input type="file" class="form-control" name="values_image_id" id="exampleInputEmail1" placeholder="Update Values Image">--}}
{{--                                    <p class="help-block"> Update The Image in Values Section</p>--}}
{{--                                </div>--}}

{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1"> Goals Image</label>--}}
{{--                                    <input type="file" class="form-control" name="goals_image_id" id="exampleInputEmail1" placeholder="Update Goals Image">--}}
{{--                                    <p class="help-block"> Update The Image in Goals Section</p>--}}
{{--                                </div>--}}




                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">تعديل معلوماتنا</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">عن الشركة</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="description_ar"
                                              id="editor5"
                                              placeholder="عن الشركةة"
                                              rows="5">{{$about->about_ar->description}}</textarea>
                                    @error('description_ar')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">قم بتعديل معلومات عن الشركة</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">المزايا</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="features_ar"
                                              id="editor5"
                                              placeholder="المزايا"
                                              rows="5">{{$about->about_ar->features_text}}</textarea>
                                    @error('features_ar')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">قم بتعديل مزايا الشركة</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">مهمتنا</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="mission_ar"
                                              id="editor6"
                                              rows="6"
                                              placeholder="عدل مهمة الشركةة">{{$about->about_ar->mission_text}}</textarea>
                                    @error('mission_ar')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">قم بتعديل مهمة الشركة</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">رؤيتنا</label>
                                    <textarea type="text"
                                              class="form-control"
                                              name="vision_ar"
                                              id="editor7"
                                              rows="6"
                                              placeholder="عدل رؤية الشركةة">{{$about->about_ar->vision_text}}</textarea>
                                    @error('vision_ar')
                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>
                                    @enderror
                                    <p class="help-block">قم بتعديل رؤية الشركة</p>
                                </div>





{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1"> قيمنا</label>--}}
{{--                                    <textarea type="text"--}}
{{--                                              class="form-control"--}}
{{--                                              name="values_ar"--}}
{{--                                              id="editor8"--}}
{{--                                              rows="6"--}}
{{--                                              placeholder="">{{$about->about_ar->values_text}}</textarea>--}}
{{--                                    @error('values_ar')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">قم بتعديل قيم الشركة</p>--}}
{{--                                </div>--}}

{{--                                <div class="col-lg-12">--}}
{{--                                    <label for="exampleInputEmail1"> اهدافنا</label>--}}
{{--                                    <textarea type="text"--}}
{{--                                              class="form-control"--}}
{{--                                              name="goals_ar"--}}
{{--                                              id="editor8"--}}
{{--                                              rows="6"--}}
{{--                                              placeholder="" >{{$about->about_ar->goals_text}}</textarea>--}}
{{--                                    @error('goals_ar')--}}
{{--                                    <p class="text-danger" style="font-weight: bold">{{$message}}</p>--}}
{{--                                    @enderror--}}
{{--                                    <p class="help-block">قم بتعديل قيم الشركة</p>--}}
{{--                                </div>--}}


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
@endsection

