<?php

namespace App\Models\Resource;

use App\Models\Album;
use App\Models\Service;

use Illuminate\Database\Eloquent\Model;

class Image extends Model
{
    protected $connection = 'mysql';

    protected $table = 'images';

    protected $fillable = ['path' , 'name' , 'alt' , 'album_id' ];


    ########eloquent#relationships########

     public function resource(){
        return $this->belongsToMany(Service::class , 'services_images' , 'image_id' , 'service_id');
     }

    public function album(){
         return $this->belongsTo(Album::class , 'album_id' , 'id');
    }

    #####end#eloquent#relationships########


    /*-===================image route functions=========================-*/
        public function imageDelete(){
          return  route('admin.images.destroy' , $this->id);
        }
    /*-================end=image route functions=========================-*/

}
