<?php

namespace App\Models;

use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    /*========over=riding==========*/
    protected $connection = 'mysql';
    protected $table = 'projects';
    /*=======end=over=riding==========*/

    /*============eloquent=relationships=================*/

    public function beforeImage(){
      return $this->belongsTo(Image::class , 'before_img_id' , 'id');
    }

    public function afterImage(){
        return $this->belongsTo(Image::class , 'after_img_id' , 'id');
    }
    /*===========end=eloquent=relationships==============*/


    /*===============rout=methods=======================*/

    public function projectEdit(){
        return route('admin.projects.edit' , $this->id);
    }

    public function projectUpdate(){
        return route('admin.projects.update' , $this->id);
    }

    public function projectDelete(){
        return route('admin.projects.destroy' , $this->id);
    }
    /*===============end=route=methods=================*/
}
