<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Comment;
use App\Models\Resource\Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class CommentController extends Controller
{
    public function index(){
        $comments = Comment::orderBy('comments.created_at' , 'desc')->with('image' , 'comment_en')->get();
        return view('dashboard.testimonials.index' , compact('comments'));
    }

    public function create(){
        return view('dashboard.testimonials.create');
    }

    public function store(Request $request){

        $request->validate([
            'fullname_en' => 'required',
            'jobtitle_en' => 'required',
            'testimonial_en' => 'required',
            'image' => 'required|mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image.';
            $img->save();
        }
        /*======================end=upload=image========================*/

        $comment = new Comment();

        if ($uploadedFile = $request->file('image')) {
            $comment->img = $img->id ;
        }

        $comment->save();

        $comment->comment_en()->create([
            'fullname' => $request['fullname_en'],
            'job_title' => $request['jobtitle_en'],
            'comment' => $request['testimonial_en']
        ]);

        $comment->comment_ar()->create([
            'fullname' => $request['fullname_ar'],
            'job_title' => $request['jobtitle_ar'],
            'comment' => $request['testimonial_ar']
        ]);

        return redirect()->route('admin.testimonials.index')->with('created' , 'testimonial created successfully!!');
    }

    public function edit(Comment $testimonial){
        $comment = $testimonial;
        $comment->load('image' , 'comment_en' , 'comment_ar');
        return view('dashboard.testimonials.edit' , compact('comment'));
    }

    public function update(Request $request , Comment $testimonial){
        $comment = $testimonial;
        $request->validate([
            'fullname_en' => 'required',
            'jobtitle_en' => 'required',
            'testimonial_en' => 'required',
            'image' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        /*===============old=image=====================*/
        if ($request->hasFile('image')) {
            $oldimage = $comment->image;
        }
        /*===============end=old=image==================*/

        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image.';
            $img->save();
        }
        /*======================end=upload=image========================*/



        if ($uploadedFile = $request->file('image')) {
            $comment->img = $img->id ;
        }

        $comment->update();

        $comment->comment_en()->update([
            'fullname' => $request['fullname_en'],
            'job_title' => $request['jobtitle_en'],
            'comment' => $request['testimonial_en']
        ]);

        $comment->comment_ar()->update([
            'fullname' => $request['fullname_ar'],
            'job_title' => $request['jobtitle_ar'],
            'comment' => $request['testimonial_ar']
        ]);

        if ($request->hasFile('image') && $oldimage) {
            $oldimage->delete();
            File::delete($oldimage->path);
        }


        return redirect()->route('admin.testimonials.index')->with('updated' , 'testimonial updated successfully!!');
    }

    public function destroy(Comment $testimonial)
    {
        $oldimage = $testimonial->image;

        if ($oldimage){
            $oldimage->delete();
            File::delete($oldimage->path);
        }
        $testimonial->comment_en()->delete();
        $testimonial->comment_ar()->delete();
        $testimonial->delete();

        return redirect()->route('admin.testimonials.index')->with('deleted' , 'testimonial deleted successfully!!');
    }
}
