<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\Resource\Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    public function index(){
        $blogs = Blog::with('blog_en'  , 'image')->orderBy('blogs.created_at' , 'desc')->get();
        return view('dashboard.blog.index' , compact('blogs'));
    }

    public function show(Blog $blog){
        $images = $blog->images()->get();
        return view('dashboard.blog.images.show' , compact('images'));
    }

    public function create(){
        return view('dashboard.blog.create');
    }

    public function store(Request $request){

        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z &:.]*$)/|max:191|unique:mysql_en.blogs,title',
            'title_ar' => 'max:191',
            'url' => 'unique:blogs',
            'subject_en' => 'required',
            'image' => 'required|mimes:jpg,jpeg,bmp,png|max:10240',
//            'images' => 'max:2',
//            'images.*' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image';
            $img->save();
        }

        /*======================end=upload=image========================*/

        /*======================upload=images========================*/
//        $imageIds = [];
//        if ($request->hasFile('images')) {
//            $uploadedFile = $request->file('images');
//            foreach ($uploadedFile as $file) {
//                $fileName = time() . $file->getClientOriginalName();
//                $file->move('dashboardImages/album', $fileName);
//                $filePath = 'dashboardImages/album/' . $fileName;
//
//                $imgs = new Image();
//                $imgs->path = $filePath ;
//                $imgs->name = $fileName;
//                $imgs->alt= $request['icon_alt'];
//                $imgs->save();
//                array_push($imageIds , $imgs->id );
//
//            }
//        }

        /*======================end=upload=images========================*/

        /*<===========initialise=service=object===========>*/
        $blog = new Blog();
        /*<==========end=initialise=service=object===========>*/

        /*<======= assign new image if exists  ======>*/
        if($request->hasFile('image')){
            $blog->image_id = $img->id;
        }
        /*<======= end assign new image if exists  ======>*/



       if ($request['url']){
           $request->validate(['url' => 'regex:/(^[a-zA-Z- ]*$)/']);
         $blog->url = Str::slug($request['url'] , '-');

        }elseif (empty($request['url'])){
          $blog->url = Str::slug($request['title_en'] , '-');
        }

        /*<=====================saving=blog=data=========================>*/
          $blog->save();
        /*<===================end=saving=blog=data=========================>*/

       /*<=====================assign=images==========================>*/
//        if ($request->hasFile('images')){
//            $blog->images()->attach($imageIds);
//        }
        /*<====================end=assign=images==========================>*/

        /*<======= create dynamic localization  ======>*/

        $blog->blog_en()->create([
            'title' => $request['title_en'],
            'subject' => $request['subject_en'],
            'author' => $request['author_en']
        ]);

        $blog->blog_ar()->create([
            'title' => $request['title_ar'],
            'subject' => $request['subject_ar'],
            'author' => $request['author_ar']
        ]);

        /*<======= end create dynamic localization  ======>*/


        return redirect()->route('admin.blog.index')->with('created','blog created successfully');
    }

    public function edit(Blog $blog){
        $blog->load('blog_en' , 'blog_ar' , 'image' , 'images');
        return view('dashboard.blog.edit' , compact('blog'));
    }

    public function update(Blog $blog , Request $request){

        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z &:.]*$)/|max:191|unique:mysql_en.blogs,title,'.$blog->blog_en->id,
            'title_ar' => 'max:191',
            'url' => 'unique:blogs,url,'.$blog->id,
            'subject_en' => 'required',
            'image' => 'mimes:jpg,jpeg,bmp,png|max:10240',
//            'images' => 'max:2',
//            'images.*' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        if ($uploadedFile = $request->file('image')) {
            $oldImage = $blog->image ;
        }


//        if ($uploadedFile = $request->file('images')){
//            $oldImages = $blog->images;
//        }

        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image';
            $img->save();
        }

        /*======================end=upload=image========================*/

        /*======================upload=images========================*/
//        $imageIds = [];
//        if ($request->hasFile('images')) {
//            $uploadedFile = $request->file('images');
//            foreach ($uploadedFile as $file) {
//                $fileName = time() . $file->getClientOriginalName();
//                $file->move('dashboardImages/album', $fileName);
//                $filePath = 'dashboardImages/album/' . $fileName;
//
//                $imgs = new Image();
//                $imgs->path = $filePath ;
//                $imgs->name = $fileName;
//                $imgs->alt= $request['icon_alt'];
//                $imgs->save();
//                array_push($imageIds , $imgs->id );
//
//            }
//        }

        /*======================end=upload=images========================*/



        /*<======= assign new image if exists  ======>*/
        if($request->hasFile('image')){
            $blog->image_id = $img->id;
        }
        /*<======= end assign new image if exists  ======>*/



        if ($request['url']){
            $request->validate(['url' => 'regex:/(^[a-zA-Z- ]*$)/']);
            $blog->url = Str::slug($request['url'] , '-');

        }elseif (empty($request['url'])){
            $blog->url = Str::slug($request['title_en'] , '-');
        }

        /*<=====================updating=blog=data=========================>*/
        $blog->update();
        /*<===================end=updating=blog=data=========================>*/

        /*<=====================assign=images==========================>*/
//        if ($request->hasFile('images')){
//            $blog->images()->attach($imageIds);
//        }
        /*<====================end=assign=images==========================>*/

        /*<======= update dynamic localization  ======>*/

        $blog->blog_en()->update([
            'title' => $request['title_en'],
            'subject' => $request['subject_en'],
            'author' => $request['author_en']
        ]);

        $blog->blog_ar()->update([
            'title' => $request['title_ar'],
            'subject' => $request['subject_ar'],
            'author' => $request['author_ar']
        ]);

        /*<======= end update  dynamic localization  ======>*/

        if ($request->file('image') &&  $oldImage) {
                $oldImage->delete();
                File::delete($oldImage->path);
        }

//        if ($request->file('images') && $oldImages){
//                foreach ($oldImages as $image){
//                     $blog->images()->detach($image->id);
//                     $image->delete();
//                     File::delete($image->path);
//                }
//        }

        return redirect()->route('admin.blog.index')->with('updated','blog updated successfully');
    }



    public function destroy(Blog $blog){

        $oldImage = $blog->image;

//        $oldImages = $blog->images;

        if ($oldImage){
            File::delete($oldImage->path);
            $oldImage->delete();
        }

//        if($oldImages){
//
//            foreach($oldImages as $img){
//                $blog->images()->detach($img->id);
//                   File::delete($img->path);
//                   $img->delete();
//               }
//        }

        $blog->delete();

        return redirect()->route('admin.blog.index')->with('deleted' , 'Blog deleted successfully!');
    }

}
