@extends('dashboard.layouts.layouts')

@section('title')
    messages
@endsection


@section('content')
    <section class="content-header">
        <h1>
            Slider
            <small>All Slides</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="https://www.accessdevelopments.com/access-admin"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="https://www.accessdevelopments.com/access-admin//message">Messages</a></li>
            <li class="active">All Message</li>
        </ol>
    </section>


    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All Messages Info</h3>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="dataTables_length" id="example2_length">
                                    <label>Show <select name="example2_length" aria-controls="example2" class="form-control input-sm">
                                            <option value="10">10</option>
                                            <option value="25">25</option>
                                            <option value="50">50</option>
                                            <option value="100">100</option>
                                        </select> entries</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div id="example2_filter" class="dataTables_filter">
                                    <label> Search:<input type="search" class="form-control input-sm" placeholder="" aria-controls="example2"></label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="">
                                    <thead>
                                    <tr role="row"><th class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-sort="ascending" aria-label="id: activate to sort column descending">id</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column ascending">Name</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Email: activate to sort column ascending">Email</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Phone: activate to sort column ascending">Phone</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Message: activate to sort column ascending">Message</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Created at: activate to sort column ascending">Created at</th><th class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Actions: activate to sort column ascending">Actions</th></tr>
                                    </thead>
                                    <tfoot>
                                    <tr><th rowspan="1" colspan="1">id</th><th rowspan="1" colspan="1">Name</th><th rowspan="1" colspan="1">Email</th><th rowspan="1" colspan="1">Phone</th><th rowspan="1" colspan="1">Message</th><th rowspan="1" colspan="1">Created at</th><th rowspan="1" colspan="1">Actions</th></tr>
                                    </tfoot>
                                    <tbody>
                                   @foreach($messages as $message )
                                    <tr role="row" class="odd">
                                        <td class="sorting_1">{{$message->id}}</td>
                                        <td>{{$message->fullname}}</td>
                                        <td>{{$message->email}}</td>
                                       <td>{{$message->phone}}</td>

                                        <td>{{$message->message}}</td>
                                        <td>{{$message->created_at}}</td>
                                        <td>
                                            <a href="{{$message->messageView()}}" class="" style="font-size: 20px"><i class="fa fa-eye"></i> </a>
                                            <button type="button" class="" data-toggle="modal" data-target="{{'#delete'.$message->id}}" style="font-size: 20px">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                       @endforeach
                                    </tbody>

                                </table></div></div><div class="row"><div class="col-sm-5"><div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to 10 of 13 entries</div></div><div class="col-sm-7"><div class="dataTables_paginate paging_simple_numbers" id="example2_paginate"><ul class="pagination"><li class="paginate_button previous disabled" id="example2_previous"><a href="#" aria-controls="example2" data-dt-idx="0" tabindex="0">Previous</a></li><li class="paginate_button active"><a href="#" aria-controls="example2" data-dt-idx="1" tabindex="0">1</a></li><li class="paginate_button "><a href="#" aria-controls="example2" data-dt-idx="2" tabindex="0">2</a></li><li class="paginate_button next" id="example2_next"><a href="#" aria-controls="example2" data-dt-idx="3" tabindex="0">Next</a></li></ul></div></div></div></div>
{{-- ********************************************delete*models***************************************************************** --}}
                    @foreach($messages as $message )
                    <div class="modal modal-danger fade" id="{{'delete'.$message->id}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span></button>
                                    <h4 class="modal-title">Delete Message</h4>
                                </div>
                                <div class="modal-body">
                                    <p>Are You Sure You Want To Delete Message <strong></strong></p>
                                </div>
                                <div class="modal-footer">
                                    <form action="{{$message->messageDelete()}}" method="post">
                                        @csrf
                                        @method('DELETE')
                                        <input type="hidden" name="_method" value="delete">
                                        <div class="d-flex flex-row">
                                            <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                cancel
                                            </button>
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    @endforeach
                </div>
            </div>
        </div>
    </section>

@endsection