<?php
    class User extends Controller{
		
        
        public function getAll()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            
            // get all interests
            $dataView['users'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `deleted` =?",array(1));
			$dataView['title'] = "Show / Edit Users";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        
        public function edit_selected()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =?  AND `deleted` =?",array($id,1));
            if($dataView['user'] == NULL)
            {
                $this->redirect("Errors","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);

            //start Edit employee
			if(isset($_POST['edit']))
            {
                
                // preparing validation array
                $validationArray = array(
                                            "name"=>array(
                                                             "value"=>$this->loadSecurity($_POST['fullName'])->clear(),
                                                             "errorName"=>"Full Name",
                                                             "rules"=>"required|min-length[4]"
                                                          ),
                                            "phone"=>array(
                                                             "value"=>$this->loadSecurity($_POST['phone'])->clear(),
                                                             "errorName"=>"Mobile Number",
                                                             "rules"=>"required"
                                                          ),
                                            "mail"=>array(
                                                             "value"=>$this->loadSecurity($_POST['email'])->clear(),
                                                             "errorName"=>"Email",
                                                             "rules"=>"required|email"
                                                          ),
                                            "address"=>array(
                                                             "value"=>$this->loadSecurity($_POST['address'])->clear(),
                                                             "errorName"=>"Address",
                                                             "rules"=>"required|min-length[3]"
                                                          ),
                                            "status"=>array(
                                                             "value"=>$this->loadSecurity($_POST['status'])->clear(),
                                                             "errorName"=>"Passenger Status",
                                                             "rules"=>"number"
                                                          ),
                                  );
                // load validation classs and pass validation data
                $dataValid = $this->loadValidation($validationArray)->formValidate();
                // check if the data is ok
                if(is_array($dataValid) && array_key_exists("success",$dataValid))
                { 
                     //check if mail exists before
                    if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `mail` =? AND `id`!=? AND `deleted`=?",array($dataValid['success']['mail'],$id,1)))
                    {
                        //check if phone exists before
                        if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `phone` =?  AND `id`!=? AND `deleted`=?",array($dataValid['success']['phone'],$id,1)))
                        {
                            // edit user data
                            $updateData = $this->loadModel("UserModel",$dataValid['success'])->updateData('id',$id);
                            if(FALSE !== $updateData)
                            {
                                $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
                                header("Refresh: 2");
                            }else{
                                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data </div>';
                            }
                        }else{
                            $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Phone Exists Before </div>';
                        }
                    }else{
                        $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Mail Exists Before </div>';
                    }
                }else{
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
                }
            }
            // set page title
			$dataView['title'] = "Edit Selected User";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_edit_selected";
            // load templatez
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function show_selected()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("error","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get trip data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
            if(!is_array($dataView['user']))
            {
                $this->redirect("Errors","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            
            
            // set page title
			$dataView['title'] = "Show User Information";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_show_selected";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function show_user_offers()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get trip data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
            if(!is_array($dataView['user']))
            {
                $this->redirect("Errors","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            
            $dataView['offers'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `id_user` =?  AND `deleted` =?",array($id,1));
            if(is_array($dataView['offers']))
            {
                foreach($dataView['offers'] as $key=>$value)
                {
                    $dataView['userOffersCategories'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category",$value['id_category']);
                }
            }			
            $dataView['title'] = "Show User Offers";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_offers_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function show_user_orders()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get trip data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
            if(!is_array($dataView['user']))
            {
                $this->redirect("Errors","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            // get requests
            $dataView['orders'] = $this->loadModel("CustomerOrderModel")->retrieveAllData("WHERE `id_customer` =?   AND `deleted` =?",array($id,1));
            //get order details
			$dataView['orderInDetails']=$this->loadModel("CustomerOrderModelDetails")->retrieveAllData("WHERE `id_order` =? AND `deleted`=?",array($id,1));
            if(is_array($dataView['orders']))
            {
                foreach($dataView['orders'] as $key=>$value)
                {
                	//get customer name
					$dataView['customer'][$key]=$this->loadModel("UserModel")->retriveDataById('id',$value['id_customer']);
                   // $dataView['product'][$key] = $this->loadModel("OfferModel")->retriveDataById("id",$value['id_product']);
					//$dataView['totalQuantity'][$key]=$this->loadModel("CustomerOrderModelDetails")->retrieveDataByQuery("
					//SELECT SUM(quantity)  AS TotalQuantuty from `order_details` WHERE  `id_order` =? AND `deleted` =?",array($value['id'],1));
				}
            }

            $dataView['title'] = "Show User Orders";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_orders_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function show_user_sales()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get trip data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
            if(!is_array($dataView['user']))
            {
                $this->redirect("Errors","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            // get requests
            $dataView['requests'] = $this->loadModel("RequestModel")->retrieveAllData("WHERE `id_reseller` =?  AND `status` =? AND `deleted` =?",array($id,1,1));
            if(is_array($dataView['requests']))
            {
                foreach($dataView['requests'] as $key=>$value)
                {
                    $dataView['offers'][$key] = $this->loadModel("OfferModel")->retriveDataById("id",$value['id_offer']);
                }
            }
            			
            $dataView['title'] = "Show User Sales";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_sales_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function show_user_addresses()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("Errors","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
             $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("Errors","index");
                exit();
            }
            // get trip data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
            if(!is_array($dataView['user']))
            {
                $this->redirect("Errors","index");
                exit();
            }
            //$dataView['user'] = array_shift($dataView['user']);
            // get requests
            $dataView['addresses'] = $this->loadModel("UserAddressModel")->retrieveAllData("WHERE `id_user` =?  AND `deleted` =?",array($id,1));

            if(is_array($dataView['addresses']))
            {
                foreach($dataView['addresses'] as $key=>$value)
                {

                    $dataView['cityEn'][$key] = $this->loadModel("CityEnModel")->retriveDataById("id_city",$value['id_city']);
                    $dataView['cityAr'][$key] = $this->loadModel("CityArModel")->retriveDataById("id_city",$value['id_city']);
                    $dataView['gove'][$key]=$this->loadModel("CityModel")->retriveDataById('id',$value['id_city']);
                    $dataView['country'][$key]=$this->loadModel("GovernateModel")->retriveDataById('id',$dataView['gove'][$key]['id_governate']);
					$dataView['govAr'][$key]=$this->loadModel("GovernateArModel")->retriveDataById('id_governate',$dataView['gove'][$key]['id_governate']);
					$dataView['govEN'][$key]=$this->loadModel("GovernateENModel")->retriveDataById('id_governate',$dataView['gove'][$key]['id_governate']);
					$dataView['country_ar'][$key]=$this->loadModel("countryArModel")->retriveDataById('id_country',$dataView['country'][$key]['id_country']);
					$dataView['country_en'][$key]=$this->loadModel("countryEnModel")->retriveDataById('id_country',$dataView['country'][$key]['id_country']);
				}
            }
            			
            $dataView['title'] = "Show User Addresses";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."user_address_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        public function updateStatus()
        {
                if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
                {
                    // get User id
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("Errors","index");
                        exit;
                    }else{
                        // get current status
                        $currentStatus = $_POST['status'];
                        // if current status = on set it off
                        if($currentStatus == "on")
                        {
                            $setStatus = 2;
                        }else{
                            $setStatus = 1;
                        }
                        $dataModel['status'] = $setStatus;

                        if(false !== $this->loadModel("UserModel",$dataModel)->updateData("id", $id))
                        {
                         echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                         exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                }
         }
        public function updateStatusUserAddress()
        {
                if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
                {
                    // get User id
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("Errors","index");
                        exit;
                    }else{
                        // get current status
                        $currentStatus = $_POST['status'];
                        // if current status = on set it off
                        if($currentStatus == "on")
                        {
                            $setStatus = 2;
                        }else{
                            $setStatus = 1;
                        }
                        $dataModel['status'] = $setStatus;

                        if(false !== $this->loadModel("UserAddressModel",$dataModel)->updateData("id", $id))
                        {
                         echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                         exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                }
         }
        public function update_image()
        {
                //get id
                $id = (int)$_POST['field_id'];
                 if($id == 0)
                {
                    $this->redirect("Errors","index");
                    exit;
                }else{
                        $upload = $this->loadUpload("image_name")->do_upload();
                       // check if there is error on image
                       if(array_key_exists("uploadError",$upload))
                       {
                           echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                            exit;

                       }else{
                           $dataModel['photo'] = $upload['uploaded'][0];
                           if(false !== $this->loadModel("UserModel",$dataModel)->updateData("id", $id))
                           {
                               echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['photo']));
                                exit; 
                           }else{
                              echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                            exit;
                           }
                       }
                    }  
        }
        public function delete()
        {
                if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
                {
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("Errors","index");
                        exit;
                    }else{
                        if(FALSE !== $this->loadModel("UserModel",array("deleted"=>2))->updateData("id",$id))
                        {
                            echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                            exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                 }
         }
        public function deleteUserAddress()
        {
                if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
                {
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("Errors","index");
                        exit;
                    }else{
                        if(FALSE !== $this->loadModel("UserAddressModel",array("deleted"=>2))->updateData("id",$id))
                        {
                            echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                            exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                 }
         }
        
    }

?>