<?php
	class Clients extends Controller{


		public function add()
		{
			/******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/


			//start Add Anew data
			if(isset($_POST['add']))
			{

				// preparing validation array
				$validationArray = array(

									"url"=>array(
										"value"=>$this->loadSecurity($_POST['url'])->clear(),
										"errorName"=>"url",
										"rules"=>"required|Url",
									),

									"status"=>array(
										"value"=>$this->loadSecurity($_POST['status'])->clear(),
										"errorName"=>"Status",
										"rules"=>"required|number"
									),

				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if(is_array($dataValid) && array_key_exists("success",$dataValid))
				{
						// upload main image
						$upload = $this->loadUpload("image")->do_upload();
						//if there is no errors
						if (!array_key_exists('uploadError', $upload))
						{
							$dataValid['success']['created']=time();
							$dataValid['success']['image'] = $upload['uploaded'][0];
							$dataValid['success']['last_updated_by'] = $user_id;
							$dataValid['success']['created_by'] = $user_id;
							// add data
							$add = $this->loadModel("ClientsModel",$dataValid['success'])->add();
							if(FALSE !== $add)
							{
								$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
								header("Refresh: 2");

							}else{
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again</div>';
							}
						}else{
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Can Not Upload Main Image (Max Size : 5MB & Allowed Extensions : png - jpg - jpeg)</div>';
						}


				}else{
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
				}
			}

			$dataView['title'] = "Add New Client";
			// global Template Config
			global $TEMPLATE_BACK_END ;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "clients" . DIRECTORY_SEPARATOR . "clients_add";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}
		public function getall()
		{
			/******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/
			//get all data
			$dataView['clients'] = $this->loadModel("ClientsModel")->retrieveAllData("WHERE  `deleted` =?",array(1));

			$dataView['title'] = "Show Clients";
			// global Template Config
			global $TEMPLATE_BACK_END ;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "clients" . DIRECTORY_SEPARATOR . "clients_getall";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}

		public function edit_selected()
		{
			/******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/
			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if($id == 0)
			{
				$this->redirect("errors","index");
				exit();
			}
			// get offer data
			$dataView['client'] = $this->loadModel("ClientsModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
			if(!is_array($dataView['client']))
			{
				$this->redirect("errors","index");
				exit();
			}
			$dataView['client'] = array_shift($dataView['client']);

			if(isset($_POST['edit'])) {

				// preparing validation array
				$validationArray = array(

									"url"=>array(
										"value"=>$this->loadSecurity($_POST['url'])->clear(),
										"errorName"=>"url",
										"rules"=>"required|Url",
									),

									"status"=>array(
										"value"=>$this->loadSecurity($_POST['status'])->clear(),
										"errorName"=>"Status",
										"rules"=>"required|number"
									),

				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {

						$dataValid['success']['last_updated_by'] = $user_id;

						$update=$this->loadModel("ClientsModel", $dataValid['success'])->updateData('id', $id);
						if(false!=$update){

							$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
							header("Refresh: 2");
						}else{
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updated Your Data Please Try Again</div>';
						}
				}else{
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';

				}
			}
			// set page title
			$dataView['title'] = "Edit a Client";
			// global Template Config
			global $TEMPLATE_BACK_END ;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "clients" . DIRECTORY_SEPARATOR . "clients_edit_selected";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}

		public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if($id == 0)
			{
				echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
				exit;
			}else{
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if(array_key_exists("uploadError",$upload))
				{
					echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
					exit;

				}else{
					$dataModel['image'] = $upload['uploaded'][0];
					$dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
					if(false !== $this->loadModel("ClientsModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['image']));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
						exit;
					}
				}
			}
		}
		public function updateStatus()
		{
			if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
			{
				// get User id
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("errors","index");
					exit;
				}else{
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if($currentStatus == "on")
					{
						$setStatus = 2;
					}else{
						$setStatus = 1;
					}
					$dataModel['status'] = $setStatus;
					$dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
					if(false !== $this->loadModel("ClientsModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}


		public function delete()
		{
			if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
			{
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("errors","index");
					exit;
				}else{
					if(FALSE !== $this->loadModel("ClientsModel",array("deleted"=>2))->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}

	}

?>