<?php

	class Project extends Controller
	{
		public function add()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/

			//start Add Anew Data
			if (isset($_POST['add'])) {

				// preparing validation array
				$validationArray = array(
					"slug" => array(
						"value" => $this->loadSecurity($_POST['slug'])->clear(),
						"errorName" => "Project slug",
						"rules" => "required|min-length[3]"
					),
					"id_category" => array(
						"value" => $this->loadSecurity($_POST['id_category'])->clear(),
						"errorName" => "Category ",
						"rules" => "required|number"
					),
					"name" => array(
						"value" => $this->loadSecurity($_POST['enName'])->clear(),
						"errorName" => "Project Name",
						"rules" => "required|min-length[3]"
					),
					"address" => array(
						"value" => $this->loadSecurity($_POST['address'])->clear(),
						"errorName" => "Project address",
						"rules" => "required|min-length[3]"
					),
					"ar_address" => array(
						"value" => $this->loadSecurity($_POST['ar_address'])->clear(),
						"errorName" => " arabic Project address",
						"rules" => "required|min-length[3]"
					),
					"location" => array(
						"value" => $this->loadSecurity($_POST['location'])->clear(),
						"errorName" => "Project location",
						"rules" => "required"
					),
					"ar_name" => array(
						"value" => $this->loadSecurity($_POST['arName'])->clear(),
						"errorName" => "اسم  المشروع",
						"rules" => "required|min-length[3]"
					),
					"description" => array(
						"value" => $this->loadSecurity($_POST['en_description'])->clear(),
						"errorName" => "Project Description",
						"rules" => "required|min-length[3]"
					),

					"ar_description" => array(
						"value" => $this->loadSecurity($_POST['ar_description'])->clear(),
						"errorName" => "وصف المشروع",
						"rules" => "required|min-length[3]"
					),
					"slug_ar" => array(
						"value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
						"errorName" => "وصف المشروع",
						"rules" => "required|min-length[3]"
					),

					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "number"
					),
				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
					// start upload image
					$upload = $this->loadUpload("image")->do_upload();
					//if there is no errors
					if (!array_key_exists('uploadError', $upload)) {

							// prepare data
							$dataModel['image'] = $upload['uploaded'][0];
							$dataModel['location'] = $dataValid['success']['location'];
							$dataModel['id_category'] = $dataValid['success']['id_category'];
							$dataModel['created_by'] = $user_id;
							$dataModel['last_updated_by'] = $user_id;
							$dataModel['status'] = $dataValid['success']['status'];
							$dataModel['created_by'] = $user_id;
							$dataModel['image'] = $upload['uploaded'][0];
							$dataModel['created'] = time();
							$add = $this->loadModel("ProjectModel", $dataModel)->add();
							// preparing en data
							$dataEnModel['id_project'] = $add;
							$dataEnModel['name'] = $dataValid['success']['name'];
							$dataEnModel['description'] = $dataValid['success']['description'];
							$dataEnModel['slug'] = $dataValid['success']['slug'];
							$dataEnModel['address'] = $dataValid['success']['address'];
							$dataEnModel['created'] = time();
							$dataEnModel['created_by'] = $user_id;
							$dataEnModel['last_updated_by'] = $user_id;
							$addEnData = $this->loadModel("ProjectEnModel", $dataEnModel)->add();
							// preparing ar data
							$dataArModel['id_project'] = $add;
							$dataArModel['slug'] = $dataValid['success']['slug_ar'];
							$dataArModel['name'] = $dataValid['success']['ar_name'];
							$dataArModel['address'] = $dataValid['success']['ar_address'];
							$dataArModel['description'] = $dataValid['success']['ar_description'];
							$dataArModel['created'] = time();
							$dataArModel['created_by'] = $user_id;
							$dataArModel['last_updated_by'] = $user_id;
							$addArData = $this->loadModel("ProjectArModel", $dataArModel)->add();
							// start add project feature
							$imagess = $this->loadUpload("images", FALSE)->do_upload();

							// check if there is error on image
							if (!array_key_exists("uploadError", $imagess)) {
								if ($imagess['uploaded'][0] != NULL) {
									foreach ($imagess['uploaded'] as $value) {
										$albumImages['id_project'] = $add;
										$albumImages['image'] = $value;
										$albumImages['created'] = time();
										$albumImages['last_updated_by'] = $user_id;
										$albumImages['created_by'] = $user_id;
										// load Model To Add Gallery Name
										$addImages = $this->loadModel("ProjectImagesModel", $albumImages)->add();
									}

								}
							}

							if (False !== $addEnData && FALSE !== $addArData && false !== $add) {
								$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
								header("Refresh: 2");
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again</div>';
							}



					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Project Image Is Required (Max Image Size 2MB)</div>';
					}

				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
				}
			}
			$dataView['allCategories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE  `status` =? AND `deleted` =?", array(1, 1));

			if (is_array($dataView['allCategories']))
			{
				foreach ($dataView['allCategories'] as $key => $data)
				{
					$dataView['allCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $data['id']);
					$dataView['allCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $data['id']);
				}
			}

			$dataView['title'] = "Add Project";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "project_add";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}





		public function getAll()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/

			// get all projects

			$dataView['projects'] = $this->loadModel("ProjectModel")->retrieveAllData("WHERE `deleted` =?", array(1));
			if (is_array($dataView['projects'])) {
				foreach ($dataView['projects'] as $key => $value) {
					// get ar and en Data
					$dataView['projectsEn'][$key] = $this->loadModel("ProjectEnModel")->retriveDataById("id_project", $value['id']);
					$dataView['projectsAr'][$key] = $this->loadModel("ProjectArModel")->retriveDataById("id_project", $value['id']);

				}
			}

			$dataView['title'] = "Show / Edit Project";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "project_getall";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}



		function edit_selected()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get data
			$dataView['project'] = $this->loadModel("ProjectModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
			if ($dataView['project'] == NULL) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['project'] = array_shift($dataView['project']);
			// get ar and en Data
			$dataView['ProjecttEn'] = $this->loadModel("ProjectEnModel")->retriveDataById("id_project", $id);
			$dataView['ProjecttAr'] = $this->loadModel("ProjectArModel")->retriveDataById("id_project", $id);


			//start Edit Brand
			if (isset($_POST['edit'])) {

				// preparing validation array

				// preparing validation array
				$validationArray = array(
					"slug" => array(
						"value" => $this->loadSecurity($_POST['slug'])->clear(),
						"errorName" => "Project slug",
						"rules" => "required|min-length[3]"
					),
					"id_category" => array(
						"value" => $this->loadSecurity($_POST['id_category'])->clear(),
						"errorName" => "Category ",
						"rules" => "required|number"
					),
					"name" => array(
						"value" => $this->loadSecurity($_POST['enName'])->clear(),
						"errorName" => "Project Name",
						"rules" => "required|min-length[3]"
					),
					"address" => array(
						"value" => $this->loadSecurity($_POST['address'])->clear(),
						"errorName" => "Project address",
						"rules" => "required|min-length[3]"
					),
					"ar_address" => array(
						"value" => $this->loadSecurity($_POST['ar_address'])->clear(),
						"errorName" => " arabic Project address",
						"rules" => "required|min-length[3]"
					),
					"location" => array(
						"value" => $this->loadSecurity($_POST['location'])->clear(),
						"errorName" => "Project location",
						"rules" => "required"
					),
					"ar_name" => array(
						"value" => $this->loadSecurity($_POST['arName'])->clear(),
						"errorName" => "اسم  المشروع",
						"rules" => "required|min-length[3]"
					),
					"description" => array(
						"value" => $this->loadSecurity($_POST['en_description'])->clear(),
						"errorName" => "Project Description",
						"rules" => "required|min-length[3]"
					),

					"ar_description" => array(
						"value" => $this->loadSecurity($_POST['ar_description'])->clear(),
						"errorName" => "وصف المشروع",
						"rules" => "required|min-length[3]"
					),
					"slug_ar" => array(
						"value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
						"errorName" => "وصف المشروع",
						"rules" => "required|min-length[3]"
					),

					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "number"
					),
				);				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
					// prepare data
					$dataModel['id_category'] = $dataValid['success']['id_category'];;
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['status'] = $dataValid['success']['status'];

					$updateData = $this->loadModel("ProjectModel", $dataModel)->UpdateData("id", $id);
					if (FALSE !== $updateData) {
						// preparing en data
						$dataEnModel['name'] = $dataValid['success']['name'];
						$dataEnModel['address'] = $dataValid['success']['address'];
						$dataEnModel['description'] = $dataValid['success']['description'];
						$dataEnModel['slug'] = $dataValid['success']['slug'];
						$dataEnModel['last_updated_by'] = $user_id;
						$updateEnData = $this->loadModel("ProjectEnModel", $dataEnModel)->UpdateData("id_project", $id);
						// preparing ar data
						$dataArModel['name'] = $dataValid['success']['ar_name'];
						$dataArModel['address'] = $dataValid['success']['ar_address'];
						$dataArModel['description'] = $dataValid['success']['ar_description'];
						$dataArModel['slug'] = $dataValid['success']['slug_ar'];
						$dataArModel['last_updated_by'] = $user_id;
						$updateArData = $this->loadModel("ProjectArModel", $dataArModel)->UpdateData("id_project", $id);
						if (False !== $updateEnData && FALSE !== $updateArData) {
							$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
							header("Refresh: 2");
						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data Please Try Again</div>';
						}
					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data Please Try Again</div>';
					}

				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
				}
			}
			$dataView['allCategories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE  `status` =? AND `deleted` =?",array(1,1));

			if(is_array($dataView['allCategories']))
			{
				foreach($dataView['allCategories'] as $key=>$data)
				{
					$dataView['allCategoriesEn'][$key] =  $this->loadModel("CategoryEnModel")->retriveDataById("id_category",$data['id']);
					$dataView['allCategoriesAr'][$key] =  $this->loadModel("CategoryArModel")->retriveDataById("id_category",$data['id']);
				}
			}


			$dataView['title'] = "Edit Selected Project";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "project_edit_selected";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}
		public function addFeatures()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get data
			$dataView['project'] = $this->loadModel("ProjectModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
			if ($dataView['project'] == NULL) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['project'] = array_shift($dataView['project']);

			if(isset($_POST['add']))
			{
				if(isset($_POST['arfeatur']) && is_array($_POST['enfeature']))
				{
					$ar_feature = $_POST['arfeatur'];
					$en_feature = $_POST['enfeature'];
					$counter = 0;
					foreach($en_feature as $key=>$value)
					{
						// check data is not empty
						if($value != NULL && $ar_feature[$key] != NULL)
						{
								//preparing en data model
							$featureArModel['id_project'] = $id;
							$featureArModel['feature'] = $ar_feature[$key];
							$featureArModel['created'] = time();
							$featureArModel['created_by'] = $user_id;
							$featureArModel['last_update_by'] = $user_id;
							$this->loadModel("ProjectFeatureArModel", $featureArModel)->add();
							$featureEnModel['id_project'] = $id;
							$featureEnModel['feature'] = $value;
							$featureEnModel['created'] = time();
							$featureEnModel['created_by'] = $user_id;
							$featureEnModel['last_update_by'] = $user_id;
							$this->loadModel("ProjectFeatureEnModel", $featureEnModel)->add();
								$counter++;

						}
					}

					if($counter == 0)
					{
						$dataView['message'] = '<div class="alert alert-warning" role="alert"><staong><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Warinig ! </strong>No Data Added (Please Add English And Arabic Data)</div>';
					}else if($counter < count($ar_feature[$key])){
						$dataView['message'] = '<div class="alert alert-warning" role="alert"><staong>
                                                <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Warning !
                                                </strong>
                                                Some Data Not Added May Be Because Of One Of Those Reasons 
                                                <br />
                                                1 - You Left Some Data Empty
                                                <br />
                                                2 - You Add English Data And Left Arabic data
                                                </div>';
					}else{
						$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong>Your Data Added Successfully Please Wait ..</div>';
						header("Refresh: 2");
					}
				}else{
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> You Did Not Add Any Feature</div>';
				}

			}



			$dataView['title'] = "Add Feature";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "add_features";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();

		}

		public function showFeature()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get data
			$dataView['project'] = $this->loadModel("ProjectModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));

			if(is_array($dataView['project']))
			{
				foreach ($dataView['project'] as $key=>$value):

					$dataView['ar_feature'][$key] = $this->loadModel("ProjectFeatureArModel")->retrieveAllData("WHERE `id_project` =? AND `deleted` =?", array($value['id'], 1));
					$dataView['en_feature'][$key] = $this->loadModel("ProjectFeatureEnModel")->retrieveAllData("WHERE `id_project` =? AND `deleted` =?", array($value['id'], 1));

				endforeach;

			}

			// set page title
			$dataView['title'] = "Project Features";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "features";
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();


		}
		public function showImages()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get data
			$dataView['project'] = $this->loadModel("ProjectModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
			if ($dataView['project'] == NULL) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['project'] = array_shift($dataView['project']);

			$dataView['Projectsimages'] = $this->loadModel("ProjectImagesModel")->retrieveAllData("WHERE  `deleted` = ? AND `id_project`=?", array(1,$id));
			$dataView['id']=$id;

			// set page title
			$dataView['title'] = "Project Images";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "project" . DIRECTORY_SEPARATOR . "images";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}
		public function add_more_images()
		{
			if (isset($_POST['action'], $_POST['id_project']) && $_POST['action'] == "addImages") {
				$user_id = $this->loadSession()->getSession("user_id");
				// upload images
				$upload = $this->loadUpload("images")->do_upload();
				$counter = 0;
				foreach ($upload['uploaded'] as $value) {

					//preparing data to be sent to model
					$albumImagesData['created_by'] = $user_id;
					$albumImagesData['id_project'] = $_POST['id_project'];
					$albumImagesData['last_updated_by'] = $user_id;
					$albumImagesData['image'] = $value;
					$albumImagesData['created']=time();
					// load Model To Add Images Name
					if ($this->loadModel("ProjectImagesModel", $albumImagesData)->add()) {
						$counter++;
					}
				}
				if ($counter == 0) {
					echo $this->loadAjax()->DataToJson(array("status" => "faild"));
					exit;
				} else if ($counter < count($upload['uploaded'])) {
					echo $this->loadAjax()->DataToJson(array("status" => "Somefaild"));
					exit;
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "success"));
					exit;
				}
			}

		}
		public function deleteimages()
		{
			if (isset($_POST['action'], $_POST['imageId']) && $_POST['action'] == "deleteImage") {

				// get image id
				$image_id = (int)$_POST['imageId'];

				if ($image_id == 0) {
					echo $this->loadAjax()->DataToJson(array("status" => "faild"));
					exit;
				} else {

					if (false !== $this->loadModel("ProjectImagesModel", array("deleted" => 2))->updateData("id", $image_id)) {
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}




	public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if ($id == 0) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;
			} else {
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if (array_key_exists("uploadError", $upload)) {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;

				} else {
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['image'] = $upload['uploaded'][0];
					if (false !== $this->loadModel("ProjectModel", $dataModel)->updateData("id", $id)) {
						echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "falid"));
						exit;
					}
				}
			}
		}


		public	function updateStatus()
		{
			if (isset($_POST['action'], $_POST['id'], $_POST['status']) && $_POST['action'] == "updateStatus") {
				// get User id
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("errors", "index");
					exit;
				} else {
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if ($currentStatus == "on") {
						$setStatus = 2;
					} else {
						$setStatus = 1;
					}
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['status'] = $setStatus;
					if (false !== $this->loadModel("ProjectModel", $dataModel)->updateData("id", $id)) {
						$this->loadModel("ProjectArModel", $dataModel)->updateData("id_project", $id);
						$this->loadModel("ProjectEnModel", $dataModel)->updateData("id_project", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}


		public	function delete()
		{
			if (isset($_POST['action'], $_POST['id']) && $_POST['action'] == "deleteData") {
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("errors", "index");
					exit;
				} else {
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if (FALSE !== $this->loadModel("ProjectModel", $dataModel)->updateData("id", $id)) {
						$this->loadModel("ProjectArModel", $dataModel)->updateData("id_project", $id);
						$this->loadModel("ProjectEnModel", $dataModel)->updateData("id_project", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}

		public	function deletefeature()
		{
			if (isset($_POST['action'], $_POST['id']) && $_POST['action'] == "deleteData") {
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("errors", "index");
					exit;
				} else {
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_update_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if ($this->loadModel("ProjectFeatureArModel", $dataModel)->updateData("id", $id)) {
						;
						$this->loadModel("ProjectFeatureEnModel", $dataModel)->updateData("id", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}


	}

?>