<?php
	class Category extends Controller{


		public function add()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("Errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			//start Add Anew Data
			if (isset($_POST['add'])) {

				// preparing validation array
				$validationArray = array(
					"name" => array(
						"value" => $this->loadSecurity($_POST['enName'])->clear(),
						"errorName" => "category Name",
						"rules" => "required|min-length[3]"
					),
					"ar_name" => array(
						"value" => $this->loadSecurity($_POST['arName'])->clear(),
						"errorName" => "اسم القسم",
						"rules" => "required|min-length[3]"
					),

					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "number"
					),
				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {

					// start upload image
					$upload = $this->loadUpload("image")->do_upload();

					//if there is no errors
					if (!array_key_exists('uploadError', $upload))
					{
						//upload advertising image
						// prepare data
						$dataModel['image'] = $upload['uploaded'][0];
						$dataModel['created_by'] = $user_id;
						$dataModel['last_update_by'] = $user_id;
						$dataModel['status'] = $dataValid['success']['status'];
						$dataModel['created'] = time();

						$add = $this->loadModel("CategoryModel", $dataModel)->add();
						if (FALSE !== $add) {

							// preparing en data
							$dataEnModel['name'] = $dataValid['success']['name'];
							$dataEnModel['id_category'] = $add;
							$addEnData = $this->loadModel("CategoryEnModel", $dataEnModel)->add();


							// preparing ar data
							$dataArModel['name'] = $dataValid['success']['ar_name'];
							$dataArModel['id_category'] = $add;
							$addArData = $this->loadModel("CategoryArModel", $dataArModel)->add();
							if (False !== $addEnData && FALSE !== $addArData) {
								$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
								header("Refresh: 2");
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again</div>';
							}


						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
						}

					}else{

						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Category Image Is Required (Max Image Size 2MB)</div>';

					}

				}

			}
				$dataView['title'] = "Add Category";
				// global Template Config
				global $TEMPLATE_BACK_END;
				// set content
				$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "category" . DIRECTORY_SEPARATOR . "category_add";
				// load template
				$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
			}


		public function getAll()
		{
			/******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("Errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/

			// get all catgories

			$dataView['categories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `deleted` =?",array(1));
			if(is_array($dataView['categories']))
			{
				foreach($dataView['categories'] as $key=>$value)
				{
					// get ar and en Data
					$dataView['categoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category",$value['id']);
					$dataView['categoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category",$value['id']);
				}
			}

			$dataView['title'] = "Show / Edit category";
			// global Template Config
			global $TEMPLATE_BACK_END ;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "category" . DIRECTORY_SEPARATOR . "category_getall";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}

		public function edit_selected()
		{
			/******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("Errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/
			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if($id == 0)
			{
				$this->redirect("Errors","index");
				exit();
			}
			// get data
			$dataView['category'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($id,1));
			if($dataView['category'] == NULL)
			{
				$this->redirect("Errors","index");
				exit();
			}
			$dataView['category'] = array_shift($dataView['category']);
			// get ar and en Data
			$dataView['categoryEn'] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category",$id);
			$dataView['categoryAr'] = $this->loadModel("CategoryArModel")->retriveDataById("id_category",$id);

			//start Edit category
			if(isset($_POST['edit']))
			{

				// preparing validation array
				$validationArray = array(
					"name" => array(
						"value" => $this->loadSecurity($_POST['enName'])->clear(),
						"errorName" => "category Name",
						"rules" => "required|min-length[3]"
					),
					"ar_name" => array(
						"value" => $this->loadSecurity($_POST['arName'])->clear(),
						"errorName" => "اسم القسم",
						"rules" => "required|min-length[3]"
					),

					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "number"
					),


				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if(is_array($dataValid) && array_key_exists("success",$dataValid))
				{
					// prepare data
					$dataModel['last_update_by'] = $user_id;
					$dataModel['status'] = $dataValid['success']['status'];

					$updateData = $this->loadModel("CategoryModel",$dataModel)->UpdateData("id",$id);
					if(FALSE !== $updateData)
					{
						// preparing en data
						$dataEnModel['name'] = $dataValid['success']['name'];
						$updateEnData = $this->loadModel("CategoryEnModel",$dataEnModel)->UpdateData("id_category",$id);
						// preparing ar data
						$dataArModel['name'] = $dataValid['success']['ar_name'];
						$updateArData = $this->loadModel("CategoryArModel",$dataArModel)->UpdateData("id_category",$id);

						// update report
						if(False !== $updateEnData && FALSE !== $updateArData)
						{
							$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
						header("Refresh: 2");
						}else{
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data Please Try Again</div>';
						}
					}else{
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data Please Try Again</div>';
					}

				}else{
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
				}
			}

			// get all catgories

			$dataView['categories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `deleted` =?",array(1));
			if(is_array($dataView['categories']))
			{
				foreach($dataView['categories'] as $key=>$value)
				{
					// get ar and en Data
					$dataView['categoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category",$value['id']);
					$dataView['categoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category",$value['id']);
				}
			}
			$dataView['title'] = "Edit Selected category";
			// global Template Config
			global $TEMPLATE_BACK_END ;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "category" . DIRECTORY_SEPARATOR . "category_edit_selected";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}
		public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if($id == 0)
			{
				echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
				exit;
			}else{
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if(array_key_exists("uploadError",$upload))
				{
					echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
					exit;

				}else{
					$dataModel['image'] = $upload['uploaded'][0];
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_update_by'] = $user_id;
					if(false !== $this->loadModel("CategoryModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['image']));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
						exit;
					}
				}
			}
		}
		public function update_adv_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if($id == 0)
			{
				echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
				exit;
			}else{
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if(array_key_exists("uploadError",$upload))
				{
					echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
					exit;

				}else{
					$dataModel['adv_image'] = $upload['uploaded'][0];
					//$dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
					if(false !== $this->loadModel("CategoryModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['adv_image']));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
						exit;
					}
				}
			}
		}
		public function updateStatus()
		{
			if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
			{
				// get User id
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if($currentStatus == "on")
					{
						$setStatus = 2;
					}else{
						$setStatus = 1;
					}
					$dataModel['status'] = $setStatus;
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_update_by'] = $user_id;
					if(false !== $this->loadModel("CategoryModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}
		public function updateArrtibutesStatus()
		{
			if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
			{
				// get User id
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if($currentStatus == "on")
					{
						$setStatus = 2;
					}else{
						$setStatus = 1;
					}
					$dataModel['status'] = $setStatus;

					if(false !== $this->loadModel("CategoryAttributesModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}
		public function delete()
		{
			if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
			{
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_update_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if(FALSE !== $this->loadModel("CategoryModel",$dataModel)->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}
		public function delete_category_images()
		{
			if(isset($_POST['action'],$_POST['imageId']) && $_POST['action'] == "deleteImage")
			{
				$id = (int)$_POST['imageId'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if(FALSE !== $this->loadModel("CategoryImagesModel",$dataModel)->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}

		}
		public function deleteadvertisngImage()
		{
			if(isset($_POST['action'],$_POST['imageId']) && $_POST['action'] == "deleteImage")
			{
				$id = (int)$_POST['imageId'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if(FALSE !== $this->loadModel("CategoryAdvertisingImagesModel",$dataModel)->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}

		}
		public function deleteAttributes()
		{
			if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
			{
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("Errors","index");
					exit;
				}else{
					if(FALSE !== $this->loadModel("CategoryAttributesModel",array("deleted"=>2))->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}

	}

?>