<?php

	class Branch extends Controller
	{

		public function add()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("Errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			//start Add Anew servicee
			if (isset($_POST['add'])) {

				// preparing validation array
				$validation_array = array(
					"name" => array(
						"value" => $this->loadSecurity($_POST['enName'])->clear(),
						"errorName" => "Branch Name",
						"rules" => "required|min-length[3]"
					),
					"address" => array(
						"value" => $this->loadSecurity($_POST['address'])->clear(),
						"errorName" => "Branch address",
						"rules" => "required|min-length[3]"
					),
					"araddress" => array(
						"value" => $this->loadSecurity($_POST['araddress'])->clear(),
						"errorName" => " العنوان",
						"rules" => "required|min-length[3]"
					),
					"arname" => array(
						"value" => $this->loadSecurity($_POST['arName'])->clear(),
						"errorName" => "Branch arabic Name",
						"rules" => "required|min-length[3]"
					),

					"phone" => array(
						"value" => $this->loadSecurity($_POST['phone'])->clear(),
						"errorName" => "Phone",
						"rules" => "required|number"
					),
					"mobile" => array(
						"value" => $this->loadSecurity($_POST['mobile'])->clear(),
						"errorName" => "Mobile",
						"rules" => "required|number"
					),



					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "number"
					),
				);
				// start validation process
				$dataAfterValidation = $this->loadValidation($validation_array)->formValidate();
				//check data is valid or not
				if (is_array($dataAfterValidation) && array_key_exists("success", $dataAfterValidation)) {
					//check if english Branch name is exist before
					if (TRUE !== $this->loadModel("BranchEnModel")->CheckExists("WHERE `title` =? AND `deleted`=?", array($dataAfterValidation['success']['name'], 1))) {
						//check if arabic service name is exist before
						if (TRUE !== $this->loadModel("BranchArModel")->CheckExists("WHERE `title` =? AND `deleted`=?", array($dataAfterValidation['success']['arname'], 1))) {
							//start add data
							$dataToModel['created'] = time();
							$dataToModel['last_updated_by'] = $user_id;
							$dataToModel['created_by'] = $user_id;
							$dataToModel['phone'] = $dataAfterValidation['success']['phone'];
							$dataToModel['mobile'] = $dataAfterValidation['success']['mobile'];
							$dataToModel['status'] = $dataAfterValidation['success']['status'];
							$add = $this->loadModel("BranchModel", $dataToModel)->add();
							//check if data added or not
							if (false !== $add) {
								// start add data in ar model
								$dataArModel['id_branch'] = $add;
								$dataArModel['title'] = $dataAfterValidation['success']['arname'];
								$dataArModel['address'] = $dataAfterValidation['success']['araddress'];
								$dataArModel['created'] = time();
								$dataArModel['last_updated_by'] = $user_id;
								$dataArModel['created_by'] = $user_id;
								$dataArModel['status'] = $dataAfterValidation['success']['status'];
								$this->loadModel("BranchArModel", $dataArModel)->add();
								//start add data in english model
								$dataEnModel['id_branch'] = $add;
								$dataEnModel['title'] = $dataAfterValidation['success']['name'];
								$dataEnModel['address'] = $dataAfterValidation['success']['address'];
								$dataEnModel['created'] = time();
								$dataEnModel['last_updated_by'] = $user_id;
								$dataEnModel['created_by'] = $user_id;
								$dataEnModel['status'] = $dataAfterValidation['success']['status'];
								$englishData = $this->loadModel("BranchEnModel", $dataEnModel)->add();
								if (false !== $englishData) {
									$dataView['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
									header("Refresh: 2");
								} else {
									$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding  Data ...</div>';
								}
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding  Data ...</div>';
							}

						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>  Arabic Name Exists Before</div>';
						}
					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>  English Name Exists Before</div>';
					}
				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataAfterValidation . '</div>';
				}

			}

			$dataView['title'] = "Add a New Branch";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "location" . DIRECTORY_SEPARATOR . "location_add";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function getAll()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("Errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			//get all service data
			$dataView['branch'] = $this->loadModel("BranchModel")->retrieveAllData("where `deleted`=?", array(1));
			if (is_array($dataView['branch'])) {
				//get all arabic and english data
				foreach ($dataView['branch'] as $key => $value):
					$dataView['branchAr'][$key] = $this->loadModel("BranchArModel")->retriveDataById('id_branch', $value['id']);
					$dataView['branchEn'][$key] = $this->loadModel("BranchEnModel")->retriveDataById('id_branch', $value['id']);
				endforeach;
			}
			$dataView['title'] = "Show / Edit Branch";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "location" . DIRECTORY_SEPARATOR . "location_getall";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function edit_selected()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("Errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			// get Service id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("Errors", "index");
				exit();
			}
			//get service data
			$dataView['branch'] = $this->loadModel("BranchModel")->retrieveAllData("WHERE `id`=? and `deleted`=?", array($id, 1));
			if (!is_array($dataView['branch'])) {
				$this->redirect("Errors", "index");
				exit();
			}
			$dataView['branch'] = array_shift($dataView['branch']);


			if (is_array($dataView['branch'])) {
				//get Servic Arabic Data and English Data
				$dataView['Arbranch'] = $this->loadModel("BranchArModel")->retriveDataById('id_branch', $dataView['branch']['id']);
				$dataView['Enbranch'] = $this->loadModel("BranchEnModel")->retriveDataById('id_branch', $dataView['branch']['id']);

			}

			//start edit Service
			if (isset($_POST['Edit'])) {
				// preparing validation array
				$validation_array = array(
										"name" => array(
											"value" => $this->loadSecurity($_POST['enName'])->clear(),
											"errorName" => "Branch Name",
											"rules" => "required|min-length[3]"
										),
										"address" => array(
											"value" => $this->loadSecurity($_POST['address'])->clear(),
											"errorName" => "Branch address",
											"rules" => "required|min-length[3]"
										),
										"araddress" => array(
											"value" => $this->loadSecurity($_POST['araddress'])->clear(),
											"errorName" => " العنوان",
											"rules" => "required|min-length[3]"
										),
										"arname" => array(
											"value" => $this->loadSecurity($_POST['arName'])->clear(),
											"errorName" => "Branch arabic Name",
											"rules" => "required|min-length[3]"
										),

										"phone" => array(
											"value" => $this->loadSecurity($_POST['phone'])->clear(),
											"errorName" => "Phone",
											"rules" => "required|number"
										),
										"mobile" => array(
											"value" => $this->loadSecurity($_POST['mobile'])->clear(),
											"errorName" => "Mobile",
											"rules" => "required|number"
										),




										"status" => array(
											"value" => $this->loadSecurity($_POST['status'])->clear(),
											"errorName" => "Status",
											"rules" => "number"
										),
				);
				// start validation process
				$dataAfterValidation = $this->loadValidation($validation_array)->formValidate();
				//check data is valid or not
				if (is_array($dataAfterValidation) && array_key_exists("success", $dataAfterValidation)) {
					//check if english service name is exist before
					if (TRUE !== $this->loadModel("BranchEnModel")->CheckExists("WHERE `title` =? AND `id`!=?  AND `deleted`=?", array($dataAfterValidation['success']['name'], $id, 1))) {
						//check if arabic service name is exist before
						if (TRUE !== $this->loadModel("BranchArModel")->CheckExists("WHERE `title` =? AND `id`!=?  AND `deleted`=?", array($dataAfterValidation['success']['arname'], $id, 1))) {
							//start update arabic date
							$dataToModel['last_updated_by'] = $user_id;
							$dataToModel['phone'] = $dataAfterValidation['success']['phone'];
							$dataToModel['status'] = $dataAfterValidation['success']['status'];
							$update = $this->loadModel("BranchModel", $dataToModel)->updateData('id', $id);
							if (false !== $update) {
								// update ar data
								$dataArModel['title'] = $dataAfterValidation['success']['arname'];
								$dataArModel['address'] = $dataAfterValidation['success']['araddress'];
								$dataArModel['last_updated_by'] = $user_id;
								$dataArModel['status'] = $dataAfterValidation['success']['status'];
								$arabicData = $this->loadModel("BranchArModel", $dataArModel)->updateData('id_branch', $id);
								//start add data in english model
								$dataEnModel['title'] = $dataAfterValidation['success']['name'];
								$dataEnModel['address'] = $dataAfterValidation['success']['address'];
								$dataEnModel['last_updated_by'] = $user_id;
								$dataEnModel['status'] = $dataAfterValidation['success']['status'];
								$englishData = $this->loadModel("BranchEnModel", $dataEnModel)->updateData('id_branch', $id);
								if (false !== $englishData) {
									$dataView['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
									header("Refresh: 2");
								} else {
									$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating  Data ...</div>';
								}
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data </div>';
							}
						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Service Arabic Name Exists Before</div>';
						}
					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Service English Name Exists Before</div>';
					}
				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataAfterValidation . '</div>';
				}


			}

			// get all interests
			$dataView['title'] = "Edit Selected Branch";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "location" . DIRECTORY_SEPARATOR . "location_edit_selected";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function updateStatus()
		{
			if (isset($_POST['action'], $_POST['id'], $_POST['status']) && $_POST['action'] == "updateStatus") {
				// get User id
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("Errors", "index");
					exit;
				} else {
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if ($currentStatus == "on") {
						$setStatus = 2;
					} else {
						$setStatus = 1;
					}
					$dataModel['status'] = $setStatus;

					if (false !== $this->loadModel("BranchModel", $dataModel)->updateData("id", $id)) {
						$this->loadModel("BranchEnModel", $dataModel)->updateData("id_branch", $id);
						$this->loadModel("BranchArModel", $dataModel)->updateData("id_branch", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}

		public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if ($id == 0) {
				$this->redirect("Errors", "index");
				exit;
			} else {
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if (array_key_exists("uploadError", $upload)) {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;

				} else {
					// get user id from session
					$last_updated_by = $this->loadSession()->getSession("user_id");
					$dataModel['image'] = $upload['uploaded'][0];
					$dataModel['last_updated_by'] = $last_updated_by;

					if (false !== $this->loadModel("BranchModel", $dataModel)->updateData("id", $id)) {
						// update Service table
						echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "falid"));
						exit;
					}
				}
			}
		}

		public function delete()
		{
			if (isset($_POST['action'], $_POST['id']) && $_POST['action'] == "deleteData") {
				//ger service id
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("Errors", "index");
					exit;
				} else {
					if (FALSE !== $this->loadModel("BranchModel", array("deleted" => 2))->updateData("id", $id)) {
						$this->loadModel("BranchEnModel", array("deleted" => 2))->updateData("id_branch", $id);
						$this->loadModel("BranchArModel", array("deleted" => 2))->updateData("id_branch", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}

		/*JSON FORMAT */
		public function retreive_all_governates_by_country_id()
		{
			if (isset($_POST['country_id'])) {
				$country_id = (int)$_POST['country_id'];
				if ($country_id !== 0) {
					$allGovernates = $this->loadModel("GovernateModel")->retrieveAllData("WHERE `id_country` = ? AND `deleted` =? AND `status` =?", array($country_id, 1, 1));
					if (is_array($allGovernates)) {
						foreach ($allGovernates as $key => $value) {
							$allGovernatesEn[$key] = $this->loadModel("GovernateEnModel")->retriveDataById("id_governate", $value['id']);
							$allGovernatesAr[$key] = $this->loadModel("GovernateArModel")->retriveDataById("id_governate", $value['id']);
						}
						$response['status'] = "success";
						$response['governates'] = $allGovernates;
						$response['governatesEn'] = isset($allGovernatesEn) ? $allGovernatesEn : NULL;
						$response['governatesAr'] = isset($allGovernatesAr) ? $allGovernatesAr : NULL;;
						echo $this->loadAjax()->DataToJson($response);
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "null"));
						exit;
					}
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "faild"));
					exit;
				}
			} else {
				echo $this->loadAjax()->DataToJson(array("status" => "faild"));
				exit;
			}
		}

	}

?>