<?php



/**

 * Template class

 *

 * this class contain the methods that set page variables and render views

 *

 *

 * LICENSE: Open source

 *

 * @category   general

 * @package    core system

 * @subpackage parent

 * @copyright  coderg

 * @license    http://coderg.com

 * @version    .01

 * @link       http://coderg.com

 * @since      2018

 */

class Template {

    private $title;

    private $description;

    private $keywords;

    //declare variables that will be used in the view

    private $pageVars;

    //declare array of templates to be loaded in sequence

    private $templateArray = array();



    /**

     * __constructor

     *

     *

     *

     * @param  $templateArray      (array)

     * @param  $pageVars(optional) (array)

     * @return none

     */

    public function __construct($templateArray, $pageVars = '') {

        $this->templateArray = $templateArray;

        $this->pageVars = $pageVars;

    }



    /**

     * render

     *

     * render template

     *

     * @param    none

     * @return   none

     *

     */

    public function render() {

        ob_start();

        $this->getBasehtml();

        $this->getTitle();

        $this->getDescription();

        $this->getKeyWords();

        $this->getJsFiles();

        $this->getCssFiles();

        echo "<meta charset='UTF-8'></head><body>";

        $langVars = $this->getLang();

        if($langVars != FALSE)

		{

            extract($langVars);

		}else{

			die("Please Check Language Config");

			exit;

		}



        if (!$this->pageVars == NULL)

        {

            extract($this->pageVars);

        }



        foreach ($this->templateArray['files'] as $pageContent) {

            require_once $pageContent . '.php';

        }



        $this->getEndhtml();

        ob_flush();

    }



    /**

     * getBasehtml

     *

     * private function

     * print the html and head opening tags

     *

     * @param    none

     * @return   none

     *

     */

    private function getBasehtml() {

        echo "<html><head><meta charset='utf-8'>".

           "<meta http-equiv='X-UA-Compatible' content='IE=edge'>

          <meta name='viewport' content='width=device-width, initial-scale=1'>".

			'<base href="'.BASE_URL_APP.'"/>'.

			"<link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Archivo+Black'  />".
			"<link rel='stylesheet'  href='https://fonts.googleapis.com/css?family=Raleway' />".
			"<link rel='stylesheet'  href='https://cdn.linearicons.com/free/1.0.0/icon-font.min.css' />".

            "<script src='https://www.google.com/recaptcha/api.js'></script>";
			"<script type='application/x-javascript'> addEventListener('load', function() { setTimeout(hideURLbar, 0); }, false);
		function hideURLbar(){ window.scrollTo(0,1); } </script>"
            ;
			//




//
    }



    /**

     * getEndhtml

     *

     * private function

     * print the html and body closing tags

     *

     * @param    none

     * @return   none

     *

     */

    private function getEndhtml() {

        echo "</body></html>";

    }



    /**

     * getCssFiles

     *

     * private

     * link the css files defined in tha cssfiles array

     *

     * @param    none

     * @return   (false) if file not found ,otherwise (none)

     *

     */

    private function getCssFiles() {

        if (is_array($this->templateArray['css'])) {

            foreach ($this->templateArray['css'] as $file) {



                    echo "<link rel='stylesheet' type='text/css' href='" .$file .'.css'. "' />";



            }

        } else

            return FALSE;

    }



    /**

     * getJsFiles

     *

     * private

     * link the js files defined in tha jsfiles array

     *

     * @param    none

     * @return   none

     *

     */

    private function getJsFiles() {

        if (is_array($this->templateArray['js'])) {



            foreach ($this->templateArray['js'] as $file) {



                    echo '<script src="' .  $file . '.js'.'"></script>';



            }

        }

    }



    /**

     * getTitle

     *

     * print the title in the title tag

     *

     * @param    none

     * @return   none

     *

     */

    public function getTitle() {

        //get the title from the database

          if(isset($this->pageVars['title']))

          {

            echo "<title>".$this->pageVars['title']."</title>";

          }

          else

          {

            echo "<title>".PROJECT_NAME."</title>";

          }

    }

    public function getDescription() {

        //get description

          if(isset($this->pageVars['description']))

          {

            echo '<meta name="description" content="'.$this->pageVars['description'].'">';

          }

    }



    public function getKeyWords() {

        //get keywords

          if(isset($this->pageVars['keyWords']))

          {

            echo '<meta name="keywords" content="'.$this->pageVars['keyWords'].'">';

          }

    }



    public function getLang()

    {

		global $templeteLang;

		if(isset($templeteLang) && $templeteLang != NULL)

        {

			$language = strtolower($templeteLang);

			if($language == "session")

			{

				if(isset($_SESSION['lang']))

				{

					$language = strtolower($_SESSION['lang']);

				}else{

					$language = "en";

				}

			}

			if(file_exists("app/langauge/main/lang_".$language.".php"))

			{

				require_once ("app/langauge/main/lang_".$language.".php");

				return $lang;

			}else{

				return FALSE;

			}

        }else{

			$language = "en";

			if(file_exists("app/langauge/main/lang_".$language.".php"))

			{

				require_once ("app/langauge/main/lang_".$language.".php");

				return $lang;

			}else{

				return FALSE;

			}

		}



        return FALSE;

    }



}

