<?php

class office extends Controller{


   public function Details()
   {
	   // get Service id from url
	   $id = (int)$this->loadRoute()->getSegment(2);
	   if($id == 0)
	   {
		   $this->redirect("errors ","index");
		   exit();
	   }

	   // get data
	   $dataView['office'] = $this->loadModel("OfficeModel")->retrieveAllData("WHERE `id` =? AND `deleted` =? AND `status`=?", array($id,1,1));
	   if ($dataView['office'] == NULL) {
		   $this->redirect("errors", "index");
		   exit();
	   }
	   $dataView['office'] = array_shift($dataView['office']);


	   $dataView['allItems']=$this->loadModel("OfficeItemModel")->retrieveAllData("WHERE `id_office`=? AND `deleted` =? AND `status`=?",array($id,1,1));
	   if(is_array($dataView['allItems'])){
		   foreach ($dataView['allItems'] as $key=>$value):
			   //get ar and en data
			   $dataView['itemLang'][$key]=$this->loadModel("OfficeItemEnModel")->retriveDataById('id_item',$value['id']);

		   endforeach;
	   }

	   $dataView['title'] = "Vertex  |Vertex";
	   // global Template Config
	   global $TEMPLATE_FRONT_END ;
	   // set content
	   $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH."office";

	   // load template
	   $this->loadTemplate($TEMPLATE_FRONT_END,$dataView)->render();

   }


	public function applyJob()
	{
		if(isset($_POST['action'])&&$_POST['action']=="applynewjob")
		{
			// preparing validation array
			$validationArray = array(
				"name"=>array(
					"value"=>$this->loadSecurity($_POST['name'])->clear(),
					"errorName"=>"  Name",
					"rules"=>"required|min-length[5]"
				),
				"message"=>array(
					"value"=>$this->loadSecurity($_POST['message'])->clear(),
					"errorName"=>"  message",
					"rules"=>"required|min-length[5]"
				),
				"id_department"=>array(
					"value"=>$this->loadSecurity($_POST['id_department'])->clear(),
					"errorName"=>" Department",
					"rules"=>"required|number"
				),
				"phone"=>array(
					"value"=>$this->loadSecurity($_POST['phone'])->clear(),
					"errorName"=>"phone",
					"rules"=>"required|number"
				),
				"age"=>array(
					"value"=>$this->loadSecurity($_POST['age'])->clear(),
					"errorName"=>"age",
					"rules"=>"required|number"
				),
				"email"=>array(
					"value"=>$this->loadSecurity($_POST['email'])->clear(),
					"errorName"=>" email",
					"rules"=>"required|email"
				),

			);
			// load validation classs and pass validation data
			$dataValid = $this->loadValidation($validationArray)->formValidate();
			// check if the data is ok
			if(is_array($dataValid) && array_key_exists("success",$dataValid))
			{
				global $uploadConfig;
				$uploadConfig['types'] = 'pdf|msword|plain';
				// start upload cv
				$upload = $this->loadUpload("myFile")->do_upload();
				if(!array_key_exists("uploadError",$upload))
				{
					$dataValid['success']['image']=$upload['uploaded'][0];
					$dataValid['success']['created']=time();
					$add = $this->loadModel("JobAppliedModel",$dataValid['success'])->add();
					if(FALSE !== $add)
					{
						$data['status'] = "success";
						$data['message'] = '<div class="alert alert-success output" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i>  Success </strong>   Data added successfully </div>';
						echo $this->loadAjax()->DataToJson($data);
						exit();
					}else{
						$data['status'] = "failed";
						$data['message'] ='<div class="alert output  alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error  in adding data</div>';
						echo $this->loadAjax()->DataToJson($data);
						exit();
					}
				}else{
					$data['status'] = "failed";
					$data['message'] ='<div class="alert output  alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error  in Uploading Cv</div>';
					echo $this->loadAjax()->DataToJson($data);
					exit();
				}


			}else{
				$data['status'] = "failed";
				$data['message'] ='<div class="alert  output alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> '.$dataValid.'</div>';
				echo $this->loadAjax()->DataToJson($data);
				exit();
			}

		}
	}

	

}

?>