<?php

	class Team extends Controller
	{


		public function add()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			//start Add Anew data
			if (isset($_POST['add'])) {

				// preparing validation array
				$validationArray = array(

					"slug" => array(
						"value" => $this->loadSecurity($_POST['slug'])->clear(),
						"errorName" => "slug",
						"rules" => "required|min-length[3]"

					),

					"name" => array(
						"value" => $this->loadSecurity($_POST['name'])->clear(),
						"errorName" => " Name",
						"rules" => "required|min-length[3]"
					),
					"job_title" => array(
						"value" => $this->loadSecurity($_POST['job_title'])->clear(),
						"errorName" => "Job Title",
						"rules" => "min-length[3]"
					),
					"name_ar" => array(
						"value" => $this->loadSecurity($_POST['name_ar'])->clear(),
						"errorName" => " Arabic Name",
						"rules" => "required|min-length[3]"
					),
					"job_title_ar" => array(
						"value" => $this->loadSecurity($_POST['job_title_ar'])->clear(),
						"errorName" => "Arabic Job Title",
						"rules" => "min-length[3]"
					),
					"slug_ar" => array(
						"value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
						"errorName" => "slug",
						"rules" => "required|min-length[3]"

					),
					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "required|number"
					),

				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
					//check if english team name is exist before
					if (TRUE !== $this->loadModel("TeamEnModel")->CheckExists("WHERE `name` =? AND `deleted`=?", array($dataValid['success']['name'], 1))) {
						//check if english team name is exist before
						if (TRUE !== $this->loadModel("TeamArModel")->CheckExists("WHERE `name` =? AND `deleted`=?", array($dataValid['success']['name_ar'], 1))) {
							// upload main image
							$upload = $this->loadUpload("image")->do_upload();
							//if there is no errors
							if (!array_key_exists('uploadError', $upload)) {
								$mainModel['created'] = time();
								$mainModel['image'] = $upload['uploaded'][0];
								$mainModel['last_updated_by'] = $user_id;
								$mainModel['status'] = $dataValid['success']['status'];
								$mainModel['created_by'] = $user_id;
								// add data
								$add = $this->loadModel("TeamModel", $mainModel)->add();
								if (FALSE !== $add) {
									//add data to ar and en
									$enModel['id_team'] = $add;
									$enModel['status'] = $dataValid['success']['status'];
									$enModel['name'] = $dataValid['success']['name'];
									$enModel['job_title'] = $dataValid['success']['job_title'];
									$enModel['slug'] = $dataValid['success']['slug'];
									$enModel['last_updated_by'] = $user_id;
									$enModel['created_by'] = $user_id;
									$enModel['created'] = time();
									$addEn = $this->loadModel("TeamEnModel", $enModel)->add();
									$arModel['id_team'] = $add;
									$arModel['status'] = $dataValid['success']['status'];
									$arModel['name'] = $dataValid['success']['name_ar'];
									$arModel['slug'] = $dataValid['success']['slug_ar'];
									$arModel['job_title'] = $dataValid['success']['job_title_ar'];
									$arModel['last_updated_by'] = $user_id;
									$arModel['created_by'] = $user_id;
									$arModel['created'] = time();
									$addAr = $this->loadModel("TeamArModel", $arModel)->add();
									if (false !== $addAr && false !== $addEn) {
										$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
										header("Refresh: 2");

									} elsE {
										$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again</div>';

									}
									$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
								} else {
									$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again</div>';
								}
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Can Not Upload Main Image (Max Size : 5MB & Allowed Extensions : png - jpg - jpeg)</div>';
							}

						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Arabic  Name Exists Before</div>';

						}

					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> English  Name Exists Before</div>';
					}
				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
				}
			}

			$dataView['title'] = "Add a Team Member";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "team" . DIRECTORY_SEPARATOR . "team_add";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function getall()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			//get all data
			$dataView['team'] = $this->loadModel("TeamModel")->retrieveAllData("WHERE  `deleted` =?", array(1));
			//get ar en data
			if (is_array($dataView['team'])) {
				foreach ($dataView['team'] as $key => $value):
					$dataView['team_ar'][$key] = $this->loadModel("TeamArModel")->retriveDataById("id_team", $value['id']);
					$dataView['team_en'][$key] = $this->loadModel("TeamEnModel")->retriveDataById("id_team", $value['id']);
				endforeach;
			}

			$dataView['title'] = "Show Team";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "team" . DIRECTORY_SEPARATOR . "getall";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function edit_selected()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get offer data
			$dataView['team'] = $this->loadModel("TeamModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
			if (!is_array($dataView['team'])) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['team'] = array_shift($dataView['team']);
			//get ar and en data
			$dataView['team_ar'] = $this->loadModel("TeamArModel")->retriveDataById("id_team", $id);
			$dataView['team_en'] = $this->loadModel("TeamEnModel")->retriveDataById("id_team", $id);
			//start Add Anew data
			if (isset($_POST['edit'])) {

				// preparing validation array
				$validationArray = array(

					"slug" => array(
						"value" => $this->loadSecurity($_POST['slug'])->clear(),
						"errorName" => "slug",
						"rules" => "required|min-length[3]"

					),

					"name" => array(
						"value" => $this->loadSecurity($_POST['name'])->clear(),
						"errorName" => " Name",
						"rules" => "required|min-length[3]"
					),
					"job_title" => array(
						"value" => $this->loadSecurity($_POST['job_title'])->clear(),
						"errorName" => "Job Title",
						"rules" => "min-length[3]"
					),
					"name_ar" => array(
						"value" => $this->loadSecurity($_POST['name_ar'])->clear(),
						"errorName" => " Arabic Name",
						"rules" => "required|min-length[3]"
					),
					"job_title_ar" => array(
						"value" => $this->loadSecurity($_POST['job_title_ar'])->clear(),
						"errorName" => "Arabic Job Title",
						"rules" => "min-length[3]"
					),
					"slug_ar" => array(
						"value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
						"errorName" => "slug",
						"rules" => "required|min-length[3]"

					),
					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => "Status",
						"rules" => "required|number"
					),
				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();
				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
					//check if english team name is exist before
					if (TRUE !== $this->loadModel("TeamEnModel")->CheckExists("WHERE `name` =? AND `id_team` !=? AND  `deleted`=?", array($dataValid['success']['name'], $id, 1))) {
						//check if english team name is exist before
						if (TRUE !== $this->loadModel("TeamArModel")->CheckExists("WHERE `name` =? AND  `id_team` !=? AND `deleted`=?", array($dataValid['success']['name_ar'], $id, 1))) {

							$mainModel['status'] = $dataValid['success']['status'];
							$mainModel['last_updated_by'] = $user_id;
							// add data
							$update = $this->loadModel("TeamModel", $mainModel)->updateData('id', $id);
							if (FALSE !== $update) {
								//update data to ar and en
								$enModel['name'] = $dataValid['success']['name'];
								$enModel['job_title'] = $dataValid['success']['job_title'];
								$enModel['slug'] = $dataValid['success']['slug'];
								$enModel['last_updated_by'] = $user_id;
								$enModel['status'] = $dataValid['success']['status'];
								$addEn = $this->loadModel("TeamEnModel", $enModel)->updateData('id_team', $id);
								$arModel['name'] = $dataValid['success']['name_ar'];
								$arModel['job_title'] = $dataValid['success']['job_title_ar'];
								$arModel['slug'] = $dataValid['success']['slug_ar'];
								$arModel['last_updated_by'] = $user_id;
								$arModel['status'] = $dataValid['success']['status'];

								$addAr = $this->loadModel("TeamArModel", $arModel)->updateData('id_team', $id);
								if (false !== $addAr && false !== $addEn) {
									$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
									header("Refresh: 2");

								} elsE {
									$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updated Your Data Please Try Again</div>';

								}
								$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
							} else {
								$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updated Your Data Please Try Again</div>';
							}

						} else {
							$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Arabic  Name Exists Before</div>';

						}

					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> English  Name Exists Before</div>';
					}
				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
				}
			}

			// set page title
			$dataView['title'] = "Edit a Team Member";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "team" . DIRECTORY_SEPARATOR . "team_edit_selected";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function show_selected()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			// get id from url
			$id = (int)$this->loadRoute()->getSegment(2);
			if ($id == 0) {
				$this->redirect("errors", "index");
				exit();
			}
			// get team data
			$dataView['team'] = $this->loadModel("TeamModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
			if (!is_array($dataView['team'])) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['team'] = array_shift($dataView['team']);
			$dataView['team_ar'] = $this->loadModel("TeamArModel")->retriveDataById("id_team", $id);
			$dataView['team_en'] = $this->loadModel("TeamEnModel")->retriveDataById("id_team", $id);

			// get team user
			$dataView['addedBy'] = $this->loadModel("UserModel")->retriveDataById("id", $dataView['team']['created_by']);
			$dataView['lastUpdatedBy'] = $this->loadModel("UserModel")->retriveDataById("id", $dataView['team']['last_updated_by']);
			// set page title
			$dataView['title'] = "Show Team Information";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "team" . DIRECTORY_SEPARATOR . "team_show_selected";

			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if ($id == 0) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;
			} else {
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if (array_key_exists("uploadError", $upload)) {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;

				} else {
					$dataModel['image'] = $upload['uploaded'][0];
					$dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
					if (false !== $this->loadModel("TeamModel", $dataModel)->updateData("id", $id)) {
						echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "falid"));
						exit;
					}
				}
			}
		}

		public function updateStatus()
		{
			if (isset($_POST['action'], $_POST['id'], $_POST['status']) && $_POST['action'] == "updateStatus") {
				// get User id
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("errors", "index");
					exit;
				} else {
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if ($currentStatus == "on") {
						$setStatus = 2;
					} else {
						$setStatus = 1;
					}
					$dataModel['status'] = $setStatus;
					$dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
					if (false !== $this->loadModel("TeamModel", $dataModel)->updateData("id", $id)) {
						$this->loadModel("TeamArModel", $dataModel)->updateData("id_team", $id);
						$this->loadModel("TeamEnModel", $dataModel)->updateData("id_team", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}


		public function delete()
		{
			if (isset($_POST['action'], $_POST['id']) && $_POST['action'] == "deleteData") {
				$id = (int)$_POST['id'];
				if ($id == 0) {
					$this->redirect("errors", "index");
					exit;
				} else {
					if (FALSE !== $this->loadModel("TeamModel", array("deleted" => 2))->updateData("id", $id)) {
						$this->loadModel("TeamArModel", array("deleted" => 2))->updateData("id_team", $id);
						$this->loadModel("TeamEnModel", array("deleted" => 2))->updateData("id_team", $id);
						echo $this->loadAjax()->DataToJson(array("status" => "success"));
						exit;
					} else {
						echo $this->loadAjax()->DataToJson(array("status" => "faild"));
						exit;
					}
				}
			}
		}

	}

?>