<?php
	class Setting extends Controller{

		public function edit()
		{
			//******** start header code ********/
			if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
			{
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
				if($dataView['userData'] == NULL)
				{
					$this->redirect("errors","index");
					exit();
				}
			}else{
				$this->redirect("admin","login");
			}

			/******* end header code *******/
			if(isset($_POST['editSetting']))
			{
				// preparing validation array
				$DataValid = array(
					"name"=>array(
						"value"=>$this->loadSecurity($_POST['name'])->clear(),
						"errorName"=>"Website Name",
						"rules"=>"min-length[4]"
					),

					"mail"=>array(
						"value"=>$this->loadSecurity($_POST['mail'])->clear(),
						"errorName"=>"Company Email",
						"rules"=>"required|email"
					),
					"commingsoon"=>array(
						"value"=>$this->loadSecurity($_POST['commingsoon'])->clear(),
						"errorName"=>"Company commingsoon",

					),
					/*
										"branches"=>array(
											"value"=>$this->loadSecurity($_POST['branches'])->clear(),
											"errorName"=>" branches",
											"rules"=>"required|number"
										),
										"support"=>array(
											"value"=>$this->loadSecurity($_POST['support'])->clear(),
											"errorName"=>" support",
											"rules"=>"required|number"
										),
										*/
					"address"=>array(
						"value"=>$this->loadSecurity($_POST['address'])->clear(),
						"errorName"=>"Company address",
						"rules"=>"required"
					),
					"phone"=>array(
						"value"=>$this->loadSecurity($_POST['phone'])->clear(),
						"errorName"=>"Company Phone",
						"rules"=>"required"
					),
					"mobile"=>array(
						"value"=>$this->loadSecurity($_POST['mobile'])->clear(),
						"errorName"=>"Company Mobile",
						"rules"=>"required"
					),


					"facebook"=>array(
						"value"=>$this->loadSecurity($_POST['facebook'])->clear(),
						"errorName"=>"FaceBook Link",
						"rules"=>"required|url"
					),
					"twitter"=>array(
						"value"=>$this->loadSecurity($_POST['twitter'])->clear(),
						"errorName"=>"Twitter Link",
						"rules"=>"required|url"
					),

					"instagram"=>array(
						"value"=>$this->loadSecurity($_POST['instagram'])->clear(),
						"errorName"=>"instagram Link",
						"rules"=>"required|url"
					),


					"youtube"=>array(
						"value"=>$this->loadSecurity($_POST['youtube'])->clear(),
						"errorName"=>"You TUbe Link",
						"rules"=>"required|url"
					),


					"name_ar"=>array(
						"value"=>$this->loadSecurity($_POST['name_ar'])->clear(),
						"errorName"=>"أسم الموقع",
						"rules"=>"min-length[4]"
					),
					"location"=>array(
						"value"=>$this->loadSecurity($_POST['location'])->clear(),
						"errorName"=>"location",
						"rules"=>"min-length[4]"
					),
					"description_ar"=>array(
						"value"=>$this->loadSecurity($_POST['description_ar'])->clear(),
						"errorName"=>"وصف الموقع",
						"rules"=>"min-length[4]"
					),
					"description"=>array(
						"value"=>$this->loadSecurity($_POST['description'])->clear(),
						"errorName"=>"description",
						"rules"=>"min-length[4]"
					),
					"address_ar"=>array(
						"value"=>$this->loadSecurity($_POST['address_ar'])->clear(),
						"errorName"=>"عنوان الشركة",
						"rules"=>"required"
					),
					/*
					"address_ar"=>array(
						"value"=>$this->loadSecurity($_POST['address_ar'])->clear(),
						"errorName"=>"عنوان الشركة",
						"rules"=>"required"
					),
					*/
					"status"=>array(
						"value"=>$this->loadSecurity($_POST['status'])->clear(),
						"errorName"=>"Website Status",
						"rules"=>"required|number",
					),

					"workhour"=>array(
						"value"=>$this->loadSecurity($_POST['workhour'])->clear(),
						"errorName"=>"work Hours ",
						"rules"=>"required"
					),
					"workhour_ar"=>array(
						"value"=>$this->loadSecurity($_POST['workhour_ar'])->clear(),
						"errorName"=>" مواعيد عمل  الشركة",
						"rules"=>"required"
					),
					/*
					"longitude"=>array(
						"value"=>$this->loadSecurity($_POST['longitude'])->clear(),
						"errorName"=>"Company longitude",
						"rules"=>"required"
					),
					"latitude"=>array(
						"value"=>$this->loadSecurity($_POST['latitude'])->clear(),
						"errorName"=>"Company latitude",
						"rules"=>"required"
					),

*/
					"commingsoon"=>array(
						"value"=>$this->loadSecurity($_POST['commingsoon'])->clear(),
						"errorName"=>"Company commingsoon",

					),
					"ar_commingsoon"=>array(
						"value"=>$this->loadSecurity($_POST['ar_commingsoon'])->clear(),
						"errorName"=>" Arabic Company commingsoon",

					),
				);
				// load validation classs and pass validation data
				$validationResult = $this->loadValidation($DataValid)->formValidate();
				// check if the data is ok
				if(is_array($validationResult)&&array_key_exists("success",$validationResult))
				{
					// preparing data model
					$dataModel['mail']=$validationResult['success']['mail'];
					//	$dataModel['agent'] = $validationResult['success']['agent'];
					//$dataModel['support']=$validationResult['success']['support'];
					//$dataModel['branches'] = $validationResult['success']['branches'];
					$dataModel['location'] = $validationResult['success']['location'];
					$dataModel['phone'] = $validationResult['success']['phone'];
					$dataModel['mobile'] = $validationResult['success']['mobile'];
					$dataModel['facebook'] = $validationResult['success']['facebook'];
					$dataModel['twitter'] = $validationResult['success']['twitter'];
					//$dataModel['google'] = $validationResult['success']['google'];
					//$dataModel['linkedin'] = $validationResult['success']['linkedin'];
					$dataModel['youtube'] = $validationResult['success']['youtube'];
					$dataModel['instagram'] = $validationResult['success']['instagram'];
					$dataModel['status'] = $validationResult['success']['status'];
					// load model and Add data
					if(FALSE !== $this->loadModel("SettingModel",$dataModel)->updateData("id",1))
					{
						// preparing lang data
						$dataModelEn['name'] = $validationResult['success']['name'];
						$dataModelEn['commingsoon'] = $validationResult['success']['commingsoon'];
						$dataModelEn['description'] = $validationResult['success']['description'];
						$dataModelEn['address'] = $validationResult['success']['address'];
						$dataModelEn['openning'] = $validationResult['success']['workhour'];
						$this->loadModel("SettingEnModel",$dataModelEn)->updateData("id_setting",1);
						// ang ar
						$dataModelAr['name'] = $validationResult['success']['name_ar'];
						$dataModelAr['description'] = $validationResult['success']['description_ar'];
						$dataModelAr['commingsoon'] = $validationResult['success']['ar_commingsoon'];
						$dataModelAr['address'] = $validationResult['success']['address_ar'];
						$dataModelAr['openning'] = $validationResult['success']['workhour_ar'];

						$this->loadModel("SettingArModel",$dataModelAr)->updateData("id_setting",1);


						$dataView['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> success </strong> Your Settings Updated Successfuly Please Wait ... </div>';
						header("Refresh: 2");
					}else{
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data</div>';
					}

				}else{
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$validationResult.'</div>';
				}
			}

			// get website date
			$site_info = $this->loadModel("SettingModel")->retrieveAllData();
			if($site_info != NULL)
			{
				$dataView['site'] = array_shift($site_info);
				$dataView['site_en'] = $this->loadModel("SettingEnModel")->retriveDataById("id_setting",1);
				$dataView['site_ar'] = $this->loadModel("SettingArModel")->retriveDataById("id_setting",1);
			}else{
				$this->redirect("Errors","index");
				exit;
			}

			// set page title
			$dataView['title'] = "Edit WebSite Information";
			// global TEMPLATE_BACK_END
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."setting_edit";
			$this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
		}
		public function update_image()
		{
			$upload = $this->loadUpload("image_name")->do_upload();
			// check if there is error on image
			if(array_key_exists("uploadError",$upload))
			{
				echo $this->loadAjax()->DataToJson(array("status"=>"falid","message"=>$upload['uploadError']));
				exit;
			}else{
				$dataModel['logo'] = $upload['uploaded'][0];
				if(false !== $this->loadModel("SettingModel",$dataModel)->updateData("id", 1))
				{
					echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['logo']));
					exit;
				}else{
					echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
					exit;
				}
			}
		}
	}

?>