<?php
	class slider extends Controller
	{

		public function add()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/


			//start add photos
			if (isset($_POST['add'])) {

				$photos = $this->loadUpload("image",FALSE)->do_upload();
				// check if there is error on image
				if(!array_key_exists("uploadError",$photos))
				{
					if($photos['uploaded'][0] != NULL)
					{
						foreach($photos['uploaded'] as $value)
						{

							$image['image'] = $value;
							$image['created'] = time();
							$image['created_by']=$user_id;
							$image['last_updated_by']=$user_id;
							$addImages = $this->loadModel("SliderModel",$image)->add();
							$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
							header("Refresh: 2");

						}

					}else{
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Can Not Upload Main Image (Max Size : 5MB & Allowed Extensions : png - jpg - jpeg)</div>';


					}

				}


			}

			$dataView['title'] = "Add a Photos To Slider";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "slider" . DIRECTORY_SEPARATOR . "add";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();

		}

		public function getAll()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/

			// get all images

			$dataView['images'] = $this->loadModel("SliderModel")->retrieveAllData("WHERE `deleted` =?", array(1));


			$dataView['title'] = "Show / Edit Images";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "slider" . DIRECTORY_SEPARATOR . "getall";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}


		public function updateStatus()
		{
			if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
			{
				// get User id
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("errors","index");
					exit;
				}else{
					// get current status
					$currentStatus = $_POST['status'];
					// if current status = on set it off
					if($currentStatus == "on")
					{
						$setStatus = 2;
					}else{
						$setStatus = 1;
					}
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['status'] = $setStatus;
					if(false !== $this->loadModel("SliderModel",$dataModel)->updateData("id", $id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}
		public function update_image()
		{
			//get id
			$id = (int)$_POST['field_id'];
			if($id == 0)
			{
				$this->redirect("errors","index");
				exit;
			}else{
				$upload = $this->loadUpload("image_name")->do_upload();
				// check if there is error on image
				if(array_key_exists("uploadError",$upload))
				{
					echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
					exit;

				}else{
					// get user id from session
					$last_updated_by = $this->loadSession()->getSession("user_id");
					$dataModel['image'] = $upload['uploaded'][0];
					$dataModel['last_updated_by'] = $last_updated_by;

					if(false !== $this->loadModel("SliderModel",$dataModel)->updateData("id", $id))
					{
						// update Service table
						echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['image']));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
						exit;
					}
				}
			}
		}

		public function delete()
		{
			if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
			{
				$id = (int)$_POST['id'];
				if($id == 0)
				{
					$this->redirect("errors","index");
					exit;
				}else{
					// get user id from session
					$user_id = $this->loadSession()->getSession("user_id");
					$dataModel['last_updated_by'] = $user_id;
					$dataModel['deleted'] = 2;
					if(FALSE !== $this->loadModel("SliderModel",$dataModel)->updateData("id",$id))
					{
						echo $this->loadAjax()->DataToJson(array("status"=>"success"));
						exit;
					}else{
						echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
						exit;
					}
				}
			}
		}


	}

?>