<?php

	class Homepage extends Controller
	{


		public function edit()
		{
			/******** start header code ********/
			if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				// get user data for header
				$dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
				if ($dataView['userData'] == NULL) {
					$this->redirect("errors", "index");
					exit();
				}
			} else {
				$this->redirect("admin", "login");
			}

			/******* end header code *******/
			//get data
			$dataView['aboutus'] = $this->loadModel("HomeModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array(1, 1));
			if ($dataView['aboutus'] == NULL) {
				$this->redirect("errors", "index");
				exit();
			}
			$dataView['aboutus'] = array_shift($dataView['aboutus']);
			// get data
			$dataView['en_name'] = $this->loadModel("HomeEnModel")->retriveDataById('id_about', 1);
			$dataView['ar_name'] = $this->loadModel("HomeArModel")->retriveDataById('id_about', 1);


			//start Edit Service
			if (isset($_POST['edit'])) {
				// preparing validation array
				$validationArray = array(

					"titleone" => array(
						"value" => $this->loadSecurity($_POST['titleone'])->clear(),
						"errorName" => " First Title Title",
						"rules" => "required|min-length[3]"
					),
					"titletwo" => array(
						"value" => $this->loadSecurity($_POST['titletwo'])->clear(),
						"errorName" => " Second  Title ",
						"rules" => "required|min-length[3]"
					),

					"description" => array(
						"value" => $this->loadSecurity($_POST['description'])->clear(),
						"errorName" => "  description",
						"rules" => "required|min-length[3]"
					),
					"ar_titleone" => array(
						"value" => $this->loadSecurity($_POST['ar_titleone'])->clear(),
						"errorName" => "  arabic First  Title",
						"rules" => "required|min-length[3]"
					),
					"ar_titletwo" => array(
						"value" => $this->loadSecurity($_POST['ar_titletwo'])->clear(),
						"errorName" => " arabic Second  Title ",
						"rules" => "required|min-length[3]"
					),

					"ar_description" => array(
						"value" => $this->loadSecurity($_POST['ar_description'])->clear(),
						"errorName" => "  arabic description",
						"rules" => "required|min-length[3]"
					),
					"susssulhome" => array(
						"value" => $this->loadSecurity($_POST['susssulhome'])->clear(),
						"errorName" => " successful home  ",
						"rules" => "required|number"
					),
					"counting" => array(
						"value" => $this->loadSecurity($_POST['counting'])->clear(),
						"errorName" => " counting",
						"rules" => "required"
					),
					"awards" => array(
						"value" => $this->loadSecurity($_POST['awards'])->clear(),
						"errorName" => " awards ",
						"rules" => "required|number"
					),

					"parteners" => array(
						"value" => $this->loadSecurity($_POST['parteners'])->clear(),
						"errorName" => " parteners",
						"rules" => "required|number"
					),
					"employee" => array(
						"value" => $this->loadSecurity($_POST['employee'])->clear(),
						"errorName" => " employee",
						"rules" => "required|number"
					),
					"projects" => array(
						"value" => $this->loadSecurity($_POST['projects'])->clear(),
						"errorName" => " projects ",
						"rules" => "required|number"
					),
					"counsulting" => array(
						"value" => $this->loadSecurity($_POST['counsulting'])->clear(),
						"errorName" => " 	counsulting ",
						"rules" => "required|number"
					),
					"url" => array(
						"value" => $this->loadSecurity($_POST['url'])->clear(),
						"errorName" => " 	Home Page Video ",
						"rules" => "required|url"
					),
					"status" => array(
						"value" => $this->loadSecurity($_POST['status'])->clear(),
						"errorName" => " status  ",
						"rules" => "required|number"
					),

				);
				// load validation classs and pass validation data
				$dataValid = $this->loadValidation($validationArray)->formValidate();

				// check if the data is ok
				if (is_array($dataValid) && array_key_exists("success", $dataValid)) {

					// prepare in  data
					$mainModel['last_updated_by'] = $user_id;
					$mainModel['status'] = $dataValid['success']['status'];
					$mainModel['susssulhome'] = $dataValid['success']['susssulhome'];
					$mainModel['counting'] = $dataValid['success']['counting'];
					$mainModel['awards'] = $dataValid['success']['awards'];
					$mainModel['projects'] = $dataValid['success']['projects'];
					$mainModel['parteners'] = $dataValid['success']['parteners'];
					$mainModel['employee'] = $dataValid['success']['employee'];
					$mainModel['url'] = $dataValid['success']['url'];
					$mainModel['counsulting'] = $dataValid['success']['counsulting'];
					$mainModel['status'] = $dataValid['success']['status'];
					$update = $this->loadModel("HomeModel", $mainModel)->updateData('id', 1);
					//start add data in differant lang

					$enlishModel['last_updated_by'] = $user_id;
					$enlishModel['titleone'] = $dataValid['success']['titleone'];
					$enlishModel['titletwo'] = $dataValid['success']['titletwo'];
					$enlishModel['description'] = $dataValid['success']['description'];
					$uppdateng = $this->loadModel("HomeEnModel", $enlishModel)->updateData('id_about', 1);
					// add arabicdata data
					$arabicModel['titleone'] = $dataValid['success']['ar_titleone'];
					$arabicModel['titletwo'] = $dataValid['success']['ar_titletwo'];
					$arabicModel['description'] = $dataValid['success']['ar_description'];
					$arabicModel['last_updated_by'] = $user_id;
					$uppdatar = $this->loadModel("HomeArModel", $arabicModel)->updateData('id_about', 1);

					if (FALSE !== $update && false !== $uppdateng && false !== $uppdatar) {
						$dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> success </strong> Your Data Updated Successfully</div>';
						header("Refresh: 2");
					} else {
						$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updated Data Please Try Again ...</div>';
					}
				} else {
					$dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
				}
			}

			$dataView['title'] = "Edit Home Page";
			// global Template Config
			global $TEMPLATE_BACK_END;
			// set content
			$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "homepage" . DIRECTORY_SEPARATOR . "aboutus_edit_selected";
			// load template
			$this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
		}

		public function update_image()
		{
			//get id
			$upload = $this->loadUpload("image_name")->do_upload();
			// check if there is error on image
			if (array_key_exists("uploadError", $upload)) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;

			} else {
				$dataModel['image'] = $upload['uploaded'][0];
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				$dataModel['last_updated_by'] = $user_id;
				if (false !== $this->loadModel("HomeModel", $dataModel)->updateData("id", 1)) {
					echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
					exit;
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;
				}
			}

		}

		public function update_image_vission()
		{
			//get id
			$upload = $this->loadUpload("image_name1")->do_upload();
			// check if there is error on image
			if (array_key_exists("uploadError", $upload)) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;

			} else {
				$dataModel['vuision_image'] = $upload['uploaded'][0];
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				$dataModel['last_updated_by'] = $user_id;
				if (false !== $this->loadModel("HomeModel", $dataModel)->updateData("id", 1)) {
					echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['vuision_image']));
					exit;
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;
				}
			}

		}

		public function update_image_mission()
		{
			//get id
			$upload = $this->loadUpload("image_name2")->do_upload();
			// check if there is error on image
			if (array_key_exists("uploadError", $upload)) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;

			} else {
				$dataModel['mission_image'] = $upload['uploaded'][0];
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				$dataModel['last_updated_by'] = $user_id;
				if (false !== $this->loadModel("HomeModel", $dataModel)->updateData("id", 1)) {
					echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['mission_image']));
					exit;
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;
				}
			}

		}

		public function update_image_main_Image()
		{
			//get id
			$upload = $this->loadUpload("image_name3")->do_upload();
			// check if there is error on image
			if (array_key_exists("uploadError", $upload)) {
				echo $this->loadAjax()->DataToJson(array("status" => "falid"));
				exit;

			} else {
				$dataModel['mainstoryimage'] = $upload['uploaded'][0];
				// get user id from session
				$user_id = $this->loadSession()->getSession("user_id");
				$dataModel['last_updated_by'] = $user_id;
				if (false !== $this->loadModel("HomeModel", $dataModel)->updateData("id", 1)) {
					echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['mainstoryimage']));
					exit;
				} else {
					echo $this->loadAjax()->DataToJson(array("status" => "falid"));
					exit;
				}
			}

		}

	}

?>