@extends('website.layouts.layout')

@section('title' , 'blog')

@section('content')

    <!--Page Title-->
    <section class="page-title" style="background-image:url({{asset('website/images/background/10.jpg')}});">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <div class="title-box">
                    <h1>{{$blog->{'blog_'.currentLang()}->title}}</h1>
                </div>
                <ul class="bread-crumb clearfix">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li>{{$blog->{'blog_'.currentLang()}->title}}</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->

    <!-- Sidebar Page Container -->
    <div class="sidebar-page-container">
        <div class="auto-container">
            <div class="row clearfix">
                <!--Content Side-->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="blog-detail">
                        <!-- News Block -->
                        <div class="news-block-two">
                            <div class="inner-box">
                                <div class="image-box">
                                    <figure class="image"><img src="{{asset($blog->image->path)}}" alt=""></figure>
                                </div>
                                <div class="caption-box">
                                    <div class="inner">
                                        <h3>{{$blog->{'blog_'.currentLang()}->title}}</h3>

                                            {!! $blog->{'blog_'.currentLang()}->subject !!}
                                    </div>
                                </div>
                            </div>
                        </div>




                    </div>
                </div>

                <!--Sidebar Side-->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar default-sidebar">


                        <!-- Latest News -->
                        <div class="sidebar-widget latest-news">
                            <div class="sidebar-title"><h3>Recent Post</h3></div>
                            <div class="widget-content">
                                @php $current = $blog->id; @endphp
                                @foreach($blogs as $blog)
                                    @if($blog->id != $current)
                                <article class="post">
                                    <div class="post-thumb"><a href="{{$blog->showBlog()}}"><img src="{{asset($blog->image->path)}}" alt=""></a></div>
                                    <h3><a href="{{$blog->showBlog()}}">{{$blog->{'blog_'.currentLang()}->title}}</a></h3>
                                    <div class="post-info">by {{ $blog->{'blog_'.currentLang()}->author }} </div>
                                </article>
                                    @endif
                                    @endforeach
                            </div>
                        </div>

                    </aside>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sidebar Container -->
    @endsection