@if ($paginator->hasPages())
    <div class="styled-pagination">
        <ul class="clearfix">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="prev-post"><a href="#"><span class="fa fa-long-arrow-left"></span> Prev</a></li>

            @else
                <li class="prev-post"><a href="{{ $paginator->previousPageUrl() }}"><span class="fa fa-long-arrow-left"></span> Prev</a></li>
            @endif

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="page-item disabled" aria-disabled="true"><span class="page-link">{{ $element }}</span></li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
{{--                            <li class="page-item active" aria-current="page"><span class="page-link">{{ $page }}</span></li>--}}
                             <li class="active"><a href="#">{{ $page }}</a></li>
                        @else
                            <li class=""><a href="{{ $url }}">{{ $page }}</a></li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="next-post"><a href="{{ $paginator->nextPageUrl() }}"> Next <span class="fa fa-long-arrow-right"></span> </a></li>
            @else
                <li class="next-post"><a href="#"> Next <span class="fa fa-long-arrow-right"></span> </a></li>
            @endif
        </ul>
    </div>
@endif
