@extends('dashboard.layouts.layouts')

@section('title')
    services
@endsection

@section('content')
    <section class="content-header">
        <h1>
            InBox
            <small>All Messages</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('admin.message.index')}}">Messages</a></li>
            <li class="active">inbox</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        @if(session()->has('deleted'))
            <div class="alert alert-danger" role="alert">
                {{ session()->get('deleted') }}
            </div>
        @endif
    </div>

    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">InBox</h3>
{{--                        <a href="{{route('admin.services.create')}}"--}}
{{--                           class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New Service </a>--}}
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example1" class="table table-bordered table-striped show-edit-category-table">
                                    <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Subject</th>
                                        <th>Message</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($messages as $message )
                                        <tr role="row" class="odd">
                                            <td class="sorting_1">{{$message->id}}</td>
                                            <td>{{$message->fullname}}</td>
                                            <td>{{$message->email}}</td>
                                            <td>{{$message->phone}}</td>
                                            <td>{{$message->subject}}</td>
                                            <td>{{$message->message}}</td>
                                            <td>{{$message->created_at->format('D M Y')}}</td>
                                            <td>
                                                <a href="{{$message->messageView()}}" class="" style="font-size: 20px"><i class="fa fa-eye"></i> </a>
                                                <button type="button" class="" data-toggle="modal" data-target="{{'#delete'.$message->id}}" style="font-size: 20px">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>

                    @foreach($messages as $message )
                        <div class="modal modal-danger fade" id="{{'delete'.$message->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span></button>
                                        <h4 class="modal-title">Delete Message</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Are You Sure You Want To Delete Message <strong>{{$message->subject}}</strong></p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="{{$message->messageDelete()}}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="_method" value="delete">
                                            <div class="d-flex flex-row">
                                                <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                    cancel
                                                </button>
                                                <button type="submit" class="btn btn-danger">
                                                    Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    @endforeach
                </div>
            </div>
        </div>
    </section>

@endsection('content')