@extends('dashboard.layouts.layouts')
@section('title', 'Dashboard')
{{--Drop Your Customized Style Codes Here--}}
@section('customizedStyle')
@endsection
{{--Drop Your Customized Scripts Codes Here--}}
@section('customizedScript')
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
@endsection
{{-- Start of page Content --}}
@section('content')

    <section class="content-header">
        <h1>
            Album
            <small>Add New Album</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl('/album')}}">Album</a></li>
            <li class="active">Add Album</li>
        </ol>
    </section>


    <section class="content">
        @include('dashboard.layouts.messages')
        <form role="form" action="{{route('admin.albums.store')}}" enctype="multipart/form-data" method="post">
            @csrf
            @method('post')
            <input type="hidden" name="created_by">
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add Album Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Album Name</label>
                                    <input type="text" class="form-control" name="title_en" id="exampleInputEmail1" placeholder="Enter Album Name" value="{{old('title_en')}}">
                                    <p class="help-block">Enter Name of Album</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Album Description</label>
                                    <input type="text" class="form-control" name="description_en" id="exampleInputEmail1" placeholder="Enter Album Description" value="{{old('description_en')}}">
                                    <p class="help-block">Enter Description of Album</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Album Type</label>
                                    <select name="type" id="admin_type" class="form-control">
                                        <option value="0">Choose Album Type</option>
                                        <option value="img">Images</option>
{{--                                        <option value="vid">Videos</option>--}}
                                    </select>
                                    <p class="help-block"> Choose type of album </p>
                                </div>
                                {{-- <input type="hidden"name="type" value="1">--}}

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input type="file" class="form-control" name="image_id" id="exampleInputEmail1" placeholder="Enter button text">
                                    <p class="help-block"> Upload Album Thumb Logo </p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات الألبوم</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">اسم الألبوم</label>
                                    <input type="text" class="form-control" name="title_ar" id="exampleInputEmail1" placeholder="ادخل اسم الألبوم" value="{{old('title_ar')}}">
                                    <p class="help-block">أدخل اسم الألبوم</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">وصف الألبوم</label>
                                    <input type="text" class="form-control" name="description_ar" id="exampleInputEmail1" placeholder="ادخل وصف الألبوم" value="{{old('description_ar')}}">
                                    <p class="help-block">أدخل وصف الألبوم</p>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

@endsection

