<?php

namespace App\Models;

use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $table = 'setting';


    /*-----------------eloquent-relationships----------------*/

    public function headerLogo()
    {
        return $this->belongsTo(Image::class , 'h_logo_id','id' );
    }

    public function footerLogo()
    {
        return $this->belongsTo(Image::class , 'f_logo_id' ,'id' );
    }
    /*----------------end-eloquent-relationships----------------*/

    /*---------------------route--functions--------------------*/

    public function settingEdit(){
        return route('admin.settings.edit' , $this->id);
    }

    public function settingUpdate(){
        return route('admin.settings.update' , $this->id);
    }

    /*------------------end--route--functions--------------------*/
}
