<?php

namespace App\Models;


//use App\Models\Resource\Image;
use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\Resource;

class Service extends Model
{
    protected $connection = 'mysql';
    protected $table = 'services';

    public function getRouteKeyName()
    {
        return 'url';
    }


    protected $fillable = ['title' , 'sub_title' , ' description' , 'image_id' , 'parent_service_id' , 'url' , 'icon_id'];


    ####Eloquent#relationships####

    public function services_en()
    {

        return $this->hasOne(\App\Models\English\Service::class , 'service_id' , 'id');
    }

    public function services_ar()
    {

        return $this->hasOne(\App\Models\Arabic\Service::class , 'service_id' , 'id');
    }

    public function image()
    {
//        return $this->hasOne(Image::class , 'id' , 'image_id');
        return $this->belongsTo(Image::class , 'image_id' , 'id');
    }

    public function icon()
    {
//        return $this->hasOne(Image::class , 'id' , 'image_id');
        return $this->belongsTo(Image::class , 'icon_id' , 'id');
    }

    public function images()
    {
        return $this->belongsToMany(Image::class , 'services_images' , 'service_id' , 'image_id');
    }

    public function childService() {
        return $this->hasMany( Service::class , 'parent_service_id' , 'id');
    }



    ###end#Eloquent#relationships####

    ############route#methods##################

      public function serviceEdit(){
        return route('admin.services.edit', $this->url);
      }

    public function serviceUpdate(){
        return route('admin.services.update', $this->url);
    }

    public function serviceDelete(){
        return route('admin.services.destroy' , $this->url);
    }

//    public function view_service(){
//        return route('show_service' , $this->id);
//    }

    public function view_service(){
        return route('show_service' , $this->url);
    }

//    public function show_sub(){
//        return route('admin.subservice.show' , $this->url);
//    }

    public function showImage(){
        return route('admin.services.show' , $this->url);
    }

//   public function create_sub(){
//       return route('admin.subservice.create' , $this->url);
//    }

//    public function create_sub(){
//        $service = $this->url;
//        return route('admin.services.create' , compact('service'));
//    }



    #########end##route#methods##################

}
