<?php

namespace App\Models\Resource;

use App\Models\Album;
use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
    protected $table = 'videos';
    protected $fillable = ['album_id' , 'url'];

    /*<=========eloquent=relationships================>*/

     public function album(){
         return $this->belongsTo(Album::class , 'album_id' , 'id');
     }

    /*<========end=eloquent=relationships=============>*/


    /*<==========rout=functions=====================>*/
    public function videoDelete(){
       return route('admin.videos.destroy' , $this->id);
    }
    /*<==========rout=functions=====================>*/
}
