<?php

namespace App\Models;

use App\Models\Resource\Image;
use App\Models\Resource\Video;
use Illuminate\Database\Eloquent\Model;

class Album extends Model
{
    protected $table = 'albums';

    public function getRouteKeyName()
    {
        return 'url';
    }


    /*-============= eloquent relationships ==================-*/

    public function album_en(){
        return $this->hasOne(\App\Models\English\Album::class , 'album_id' , 'id');
    }

    public function album_ar(){
        return $this->hasOne(\App\Models\Arabic\Album::class , 'album_id' , 'id');
    }

    public function image(){
        return $this->hasOne(Image::class ,   'id' , 'image_id');
    }

    public function images(){
        return $this->hasMany(Image::class , 'album_id' , 'id');
    }


    public function videos(){
        return $this->hasMany(Video::class , 'album_id' , 'id');
    }





    /*-============= end eloquent relationships =============-*/



    /*-============= route functions ==================-*/

     public function albumEdit(){
         return route('admin.albums.edit' , $this->url);
     }

    public function albumUpdate(){
        return route('admin.albums.update' , $this->url);
    }

    public function albumDelete(){
        return route('admin.albums.destroy' , $this->url);
    }


    public function showImages(){
        return route('admin.albums.show' , $this->url);
    }

    public function view(){
         return route('show_album' , $this->url);
    }



    /*-============= end route functions =============-*/

}
