<?php

namespace App\Models;

use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;

class About extends Model
{
   protected $table = 'about';

   /*----eloquent-relationships----*/
    public function about_en(){
        return $this->hasOne(\App\Models\English\About::class , 'about_id' , 'id');
    }

    public function about_ar(){
        return $this->hasOne(\App\Models\Arabic\About::class , 'about_id' , 'id');
    }

    public function values_image(){
        return $this->belongsTo(Image::class , 'values_img' , 'id');
    }

    public function vision_image(){
        return $this->belongsTo(Image::class , 'vision_img' , 'id');
    }

    public function about_image(){
        return $this->belongsTo(Image::class , 'about_img' , 'id');
    }

    public function mission_image(){
        return $this->belongsTo(Image::class , 'mission_img' , 'id');
    }

    public function features_image(){
        return $this->belongsTo(Image::class , 'features_img' , 'id');
    }


    /*---end-eloquent-relationships----*/


    /*----------route-functions---------------*/
     public function aboutEdit(){
         return route('admin.about.edit' , $this->id);
     }

     public function aboutUpdate(){
         return route('admin.about.update' , $this->id);
     }
    /*--------end-route-functions-------------*/
}
