<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Resource\Image;
use App\Models\Resource\Video;
use Illuminate\Http\Request;
use App\Models\Album;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;


class AlbumController extends Controller
{
    public function index(){
        $albums = Album::orderBy('albums.created_at' , 'desc')->with('album_en' , 'album_ar' , 'image')->get();
        return view('dashboard.albums.index' , compact('albums'));
    }

    public function show(Album $album){
        if($album->type === 'vid') {
            $videos = $album->videos()->get();
            return view('dashboard.albums.videos.show' , compact('videos'));
        }
       $images = $album->images()->get();
       return view('dashboard.albums.images.show' , compact('images'));
    }

    public function create(){
        return view('dashboard.albums.create');
    }

    public function store(Request $request)
    {

        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z ]*$)/|max:191|unique:mysql_en.albums,title',
            'title_ar' => 'max:191',
            'type' => 'required|not_in:0',
            'image_id' => 'mimes:jpg,jpeg,bmp,png|max:10240',
        ]);

        /*=======================upload=image========================*/
        if ($uploadedFile = $request->file('image_id')) {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= $request['alt'];
            $img->save();
        }

        /*======================end=upload=image========================*/

        $album = new Album();

        if($request->hasFile('image_id')){
            $album->image_id = $img->id;
        }

        $album->url =  Str::slug($request['title_en'] , '-');

        $album->type = $request['type'];

        $album->save();

        $album->album_en()->create([
            'title' => $request['title_en'],
            'description' => $request['description_en']
        ]);

        $album->album_ar()->create([
            'title' => $request['title_ar'],
            'description' => $request['description_ar']
        ]);


        return redirect()->route('admin.albums.index')->with('created' , 'album created successfully!');
    }



    public function upload(Album $album){
        if($album->type === 'vid') {
            $album->load('album_en');
            return view('dashboard.albums.videos.add', compact('album'));
        }
        $album->load('album_en');
        return view('dashboard.albums.images.upload', compact('album'));
    }

    public function store_video(Request $request ,Album $album){
        $request->validate([
            'video_url' => 'required|url'
        ]);
       $album->videos()->create([
           'url' => $request['video_url']
       ]);

        return redirect()->route('admin.albums.index')->with('uploaded' , 'Video Url Added successfully!');
    }

    public function store_image(Request $request ,Album $album){

        $request->validate([
            'image_id' => 'required|max:10',
            'image_id.*' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        /*======================upload=images========================*/

        if ($uploadedFile = $request->file('image_id')) {
            foreach ($uploadedFile as $file) {

                $fileName = time() . $file->getClientOriginalName();
                $file->move('dashboardImages/album', $fileName);
                $filePath = 'dashboardImages/album/' . $fileName;
                $imgs = new Image();
                $imgs->path = $filePath ;
                $imgs->name = $fileName;
                $imgs->album_id = $album->id;
                $imgs->alt= "i'm an image";
                $imgs->save();
            }
        }

        /*======================end=upload=images========================*/

        return redirect()->route('admin.albums.index')->with('uploaded' , 'images uploaded successfully!');
    }

    public function edit(Album $album){
        $album->load('album_en' , 'album_ar' )->get();
        return view('dashboard.albums.edit' , compact('album'));
    }

    public function update(Album $album , Request $request){

        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z ]*$)/|max:191|unique:mysql_en.albums,title,'.$album->album_en->id,
            'title_ar' => 'max:191',
            'type' => 'required',
            'image_id' => 'mimes:jpg,jpeg,bmp,png|max:10240',
        ]);

        if($request->hasFile('image_id')){
                $oldImg = $album->image ;
        }


        /*=======================upload=image========================*/
        if ($uploadedFile = $request->file('image_id')) {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= "i'm an image";
            $img->save();
        }

        /*======================end=upload=image========================*/

        if($request->hasFile('image_id')){
           $album->image_id = $img->id;
        }

        $album->url =  Str::slug($request['title_en'] , '-');
        $album->type = $request['type'];
        $album->update();

        $album->album_en()->update([
            'title' => $request['title_en'],
            'description' => $request['description_en']
        ]);

        $album->album_ar()->update([
            'title' => $request['title_ar'],
            'description' => $request['description_ar']
        ]);

        if($request->hasFile('image_id')){
            /*------------delete-image----------------*/
            if ($oldImg) {
                File::delete($oldImg->path);
                $oldImg->delete();
            }
            /*----------end-delete-image----------------*/
        }

        return redirect()->route('admin.albums.index')->with('updated' , 'album updated successfully!');
    }

    public function destroy(Album $album){
          /*<====delete=thumbnail=image===>*/

        $oldImage  = $album->image;

        $oldImages = $album->images;


        if($oldImage){
            File::delete($oldImage->path);
            $oldImage->delete();
        }
        /*<===end=delete=thumbnail=image===>*/

        /*<====delete=uploaded=images===>*/
        if($oldImages){
            foreach ($oldImages as $image){
                File::delete($image->path);
                $image->delete();
            }
        }
        /*<===end=delete=uploaded=images===>*/

        $album->delete();


        return redirect()->route('admin.albums.index')->with('deleted' , 'Album deleted successfully!');
    }
}
